/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.data.security.filter;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.efficient.common.exception.DataSecurityException;
import com.efficient.data.security.filter.RequestWrapper;
import com.efficient.data.security.properties.DataSecurityProperties;
import com.efficient.data.security.util.AESUtils;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.mvc.condition.PatternsRequestCondition;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@ConditionalOnProperty(name={"com.efficient.data.requestEnable"}, havingValue="true")
@Component
public class ReplaceStreamFilter
implements Filter {
    @Autowired
    WebApplicationContext applicationContext;
    private Map<String, Method> METHOD_MAP;
    @Autowired
    private AESUtils aesUtils;
    @Autowired
    private DataSecurityProperties properties;
    @Autowired
    private HandlerExceptionResolver handlerExceptionResolver;

    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        this.initMethod();
        String contentType = "multipart/form-data";
        String reqContentType = servletRequest.getContentType();
        if (StrUtil.isNotBlank((CharSequence)reqContentType) && reqContentType.contains(contentType)) {
            ServletRequest requestWrapper = servletRequest;
            filterChain.doFilter(requestWrapper, servletResponse);
        } else {
            try {
                RequestWrapper requestWrapper = new RequestWrapper((HttpServletRequest)servletRequest, this.aesUtils, this.properties, this.METHOD_MAP.get(((HttpServletRequest)servletRequest).getRequestURI()));
                filterChain.doFilter((ServletRequest)requestWrapper, servletResponse);
            }
            catch (Exception e) {
                this.handlerExceptionResolver.resolveException((HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse, null, (Exception)new DataSecurityException((Throwable)e));
            }
        }
    }

    public void destroy() {
        super.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initMethod() {
        if (CollUtil.isEmpty(this.METHOD_MAP)) {
            ReplaceStreamFilter replaceStreamFilter = this;
            synchronized (replaceStreamFilter) {
                if (CollUtil.isEmpty(this.METHOD_MAP)) {
                    this.METHOD_MAP = new HashMap<String, Method>();
                    RequestMappingHandlerMapping mappingHandlerMapping = (RequestMappingHandlerMapping)this.applicationContext.getBean("requestMappingHandlerMapping", RequestMappingHandlerMapping.class);
                    Map handlerMethods = mappingHandlerMapping.getHandlerMethods();
                    handlerMethods.forEach((key, value) -> {
                        PatternsRequestCondition p = key.getPatternsCondition();
                        String reqUrl = null;
                        Iterator iterator = p.getPatterns().iterator();
                        while (iterator.hasNext()) {
                            String url;
                            reqUrl = url = (String)iterator.next();
                        }
                        this.METHOD_MAP.put(reqUrl, value.getMethod());
                    });
                }
            }
        }
    }
}

