/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.data.security.handler;

import cn.hutool.json.JSONUtil;
import com.efficient.common.exception.DataSecurityException;
import com.efficient.common.result.Result;
import com.efficient.data.security.annotation.ResponseEncrypt;
import com.efficient.data.security.annotation.SecuritySkip;
import com.efficient.data.security.constant.EnableType;
import com.efficient.data.security.properties.DataSecurityProperties;
import com.efficient.data.security.util.AESUtils;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@ConditionalOnProperty(name={"com.efficient.security.api.responseEnable"}, havingValue="true")
@ControllerAdvice
public class ResponseDataSecurity
implements ResponseBodyAdvice<Result> {
    private static final Logger log = LoggerFactory.getLogger(ResponseDataSecurity.class);
    @Autowired
    private DataSecurityProperties properties;
    @Autowired
    private AESUtils aesUtils;

    public boolean supports(MethodParameter methodParameter, Class converterType) {
        SecuritySkip skip = (SecuritySkip)methodParameter.getMethodAnnotation(SecuritySkip.class);
        if (Objects.nonNull(skip) && skip.skipResponse()) {
            return false;
        }
        if (Objects.equals((Object)this.properties.getApi().getResponseEnableType(), (Object)EnableType.NEED)) {
            return methodParameter.hasMethodAnnotation(ResponseEncrypt.class);
        }
        return Objects.equals((Object)this.properties.getApi().getResponseEnableType(), (Object)EnableType.NODE);
    }

    public Result beforeBodyWrite(Result body, MethodParameter returnType, MediaType selectedContentType, Class selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        try {
            Object bodyData = body.getData();
            if (bodyData != null) {
                body.setData((Object)this.aesUtils.encrypt(JSONUtil.toJsonStr((Object)bodyData)));
            }
        }
        catch (Exception e) {
            throw new DataSecurityException((Throwable)e);
        }
        return body;
    }
}

