/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.data.security.db.interceptor;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
import com.efficient.data.security.annotation.DbEncrypted;
import com.efficient.data.security.db.crypt.DbAES;
import com.efficient.data.security.util.ReflectionUtil;
import java.sql.Statement;
import java.util.List;
import java.util.Objects;
import org.apache.ibatis.executor.resultset.ResultSetHandler;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Intercepts(value={@Signature(type=ResultSetHandler.class, method="handleResultSets", args={Statement.class})})
@Component
public class EncryptInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(EncryptInterceptor.class);
    private static final String MAPPED_STATEMENT = "mappedStatement";
    @Autowired
    private DbAES dbAES;

    public Object intercept(Invocation invocation) throws Throwable {
        if (!DbAES.dbEncryptEnable) {
            return invocation.proceed();
        }
        List results = (List)invocation.proceed();
        if (results.isEmpty()) {
            return results;
        }
        Object result0 = results.get(0);
        if (Objects.isNull(result0)) {
            return results;
        }
        Class<?> result0Class = result0.getClass();
        DbEncrypted encryptEnabled = result0Class.getAnnotation(DbEncrypted.class);
        List<String> list = ReflectionUtil.ENCRYPT_MAP.get(result0Class.getTypeName());
        if (encryptEnabled == null || !encryptEnabled.value() || CollUtil.isEmpty(list)) {
            return results;
        }
        ResultSetHandler statementHandler = (ResultSetHandler)PluginUtils.realTarget((Object)invocation.getTarget());
        MetaObject metaObject = SystemMetaObject.forObject((Object)statementHandler);
        MappedStatement mappedStatement = (MappedStatement)metaObject.getValue(MAPPED_STATEMENT);
        for (Object obj : results) {
            if (!Objects.nonNull(obj)) continue;
            MetaObject objMetaObject = mappedStatement.getConfiguration().newMetaObject(obj);
            for (String fieldName : list) {
                String value = (String)objMetaObject.getValue(fieldName);
                objMetaObject.setValue(fieldName, (Object)this.dbAES.decrypt(value));
            }
        }
        return results;
    }
}

