/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.data.security.util;

import com.efficient.data.security.annotation.DbEncrypted;
import com.efficient.data.security.annotation.DbFieldEncrypted;
import com.efficient.data.security.db.crypt.DbAES;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.reflections.Reflections;

public class ReflectionUtil {
    public static final Map<String, List<String>> ENCRYPT_MAP = ReflectionUtil.initEncryptData();

    public static Map<String, List<String>> initEncryptData() {
        String dbEncryptModelPath = DbAES.dbEncryptModelPath;
        Object[] modelPath = dbEncryptModelPath.split(",");
        Reflections reflections = new Reflections(modelPath);
        Set classesList = reflections.getTypesAnnotatedWith(DbEncrypted.class);
        HashMap<String, List<String>> mapList = new HashMap<String, List<String>>(128);
        for (Class classes : classesList) {
            String typeName = classes.getTypeName();
            LinkedList list = new LinkedList();
            Field[] fields = classes.getDeclaredFields();
            Arrays.stream(fields).filter(field -> Objects.nonNull(field.getAnnotation(DbFieldEncrypted.class))).forEach(field -> list.add(field.getName()));
            if (list.isEmpty()) continue;
            mapList.put(typeName, list);
        }
        return mapList;
    }
}

