/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.elasticsearch.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.efficient.common.page.Page;
import com.efficient.common.util.JackSonUtil;
import com.efficient.elasticsearch.entity.ResponseEntity;
import com.efficient.elasticsearch.parser.SqlParser;
import com.efficient.elasticsearch.parser.TableNameParser;
import com.efficient.elasticsearch.properties.ElasticSearchProperties;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.HttpAsyncResponseConsumerFactory;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.core.CountRequest;
import org.elasticsearch.client.core.CountResponse;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.CreateIndexResponse;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.elasticsearch.client.indices.GetMappingsRequest;
import org.elasticsearch.client.indices.GetMappingsResponse;
import org.elasticsearch.client.indices.PutMappingRequest;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.UpdateByQueryRequest;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticSearchService {
    private static final Logger log = LoggerFactory.getLogger(ElasticSearchService.class);
    public static final String PK_FIELD_NAME = "id";
    public static final Long MAX_BUCKETS = 20000000L;
    public RestHighLevelClient restHighLevelClient = null;
    private boolean dateToTimestamp = false;
    private RestClient restClient = null;
    private SqlParser sqlParser = null;
    private ElasticSearchProperties properties;

    public void init(ElasticSearchProperties elasticSearchProperties) {
        this.properties = elasticSearchProperties;
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.properties.getUsername(), this.properties.getPassword()));
        RestClientBuilder builder = RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(this.properties.getIp(), this.properties.getPort().intValue())}).setHttpClientConfigCallback(arg_0 -> this.lambda$init$0((CredentialsProvider)credentialsProvider, arg_0)).setRequestConfigCallback(restClientBuilder -> {
            restClientBuilder.setConnectTimeout(this.properties.getConnectTimeout().intValue());
            restClientBuilder.setSocketTimeout(this.properties.getSocketTimeout().intValue());
            restClientBuilder.setConnectionRequestTimeout(this.properties.getConnectionRequestTimeout().intValue());
            return restClientBuilder;
        });
        this.restClient = builder.build();
        this.restHighLevelClient = new RestHighLevelClient(builder);
        this.sqlParser = new SqlParser(this.properties);
        this.dateToTimestamp = this.properties.isDateToTimestamp();
    }

    public boolean destroy() {
        try {
            if (Objects.nonNull(this.restClient)) {
                this.restClient.close();
            }
            if (Objects.nonNull(this.restHighLevelClient)) {
                this.restHighLevelClient.close();
            }
        }
        catch (Exception e) {
            log.error("\u5173\u95ed restHighLevelClient \u5931\u8d25 ", (Throwable)e);
            return false;
        }
        return true;
    }

    public boolean createIndex(String index) throws IOException {
        if (this.isIndexExist(index)) {
            log.error("Index is exits!");
            return false;
        }
        CreateIndexRequest request = new CreateIndexRequest(index);
        request.settings(Settings.builder().put("number_of_shards", 1).put("number_of_replicas", 0).put("max_result_window", 20000000).build());
        CreateIndexResponse response = this.restHighLevelClient.indices().create(request, RequestOptions.DEFAULT);
        log.info("\u521b\u5efa\u7d22\u5f15{}\u6210\u529f", (Object)index);
        return response.isAcknowledged();
    }

    public boolean isIndexExist(String index) throws IOException {
        GetIndexRequest request = new GetIndexRequest(new String[]{index});
        return this.restHighLevelClient.indices().exists(request, RequestOptions.DEFAULT);
    }

    public boolean deleteIndex(String index) throws IOException {
        if (!this.isIndexExist(index)) {
            log.error("Index is not exits!");
            return false;
        }
        DeleteIndexRequest request = new DeleteIndexRequest(index);
        AcknowledgedResponse delete = this.restHighLevelClient.indices().delete(request, RequestOptions.DEFAULT);
        log.info("\u5220\u9664\u7d22\u5f15{}\u6210\u529f", (Object)index);
        return delete.isAcknowledged();
    }

    public boolean save(String index, Map<String, Object> data) {
        IndexRequest request = new IndexRequest(index);
        request.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        this.formatMap(data);
        request.source(data).opType(DocWriteRequest.OpType.INDEX);
        try {
            IndexResponse response = this.restHighLevelClient.index(request, RequestOptions.DEFAULT);
            DocWriteResponse.Result result = response.getResult();
            if (Objects.equals(result, DocWriteResponse.Result.UPDATED)) {
                log.warn("\u65b0\u589e\u6587\u6863\u5df2\u5b58\u5728\uff0c\u9ed8\u8ba4\u6267\u884c\u4e86\u4fee\u6539\u64cd\u4f5c\uff1a" + JackSonUtil.toJson(data));
                return true;
            }
            log.info("\u7d22\u5f15\u4e3a: {}, \u65b0\u589e\u6570\u636e\u6210\u529f", (Object)index);
            return Objects.equals(result, DocWriteResponse.Result.CREATED);
        }
        catch (IOException e) {
            log.error(index + " \u6279\u91cf\u4fdd\u5b58\u5931\u8d25", (Throwable)e);
            return false;
        }
    }

    private Map<String, Object> formatMap(Map<String, Object> map) {
        map.keySet().forEach(key -> map.compute((String)key, (k, value) -> this.formatValue(value)));
        return map;
    }

    private Object formatValue(Object value) {
        if (Objects.isNull(value)) {
            return null;
        }
        if (value instanceof Date) {
            long dateLong = ((Date)value).getTime();
            if (this.dateToTimestamp) {
                return this.processDateLong(dateLong);
            }
            return new java.util.Date(dateLong);
        }
        if (value instanceof Timestamp) {
            long dateLong = ((Timestamp)value).getTime();
            if (this.dateToTimestamp) {
                return this.processDateLong(dateLong);
            }
            return new java.util.Date(dateLong);
        }
        if (value instanceof java.util.Date) {
            java.util.Date date = (java.util.Date)value;
            if (this.dateToTimestamp) {
                return DateUtil.beginOfDay((java.util.Date)date).getTime();
            }
            return date;
        }
        return value;
    }

    private Long processDateLong(long dateLong) {
        return DateUtil.beginOfDay((java.util.Date)new java.util.Date(dateLong)).getTime();
    }

    public boolean saveByPkField(String index, Map<String, Object> data) {
        return this.saveByPkField(index, PK_FIELD_NAME, data);
    }

    public boolean saveByPkField(String index, String pkFieldName, Map<String, Object> data) {
        IndexRequest request = new IndexRequest(index);
        request.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        this.formatMap(data);
        request.source(data).opType(DocWriteRequest.OpType.INDEX);
        if (StrUtil.isNotBlank((CharSequence)pkFieldName)) {
            request.id(String.valueOf(data.get(pkFieldName)));
        }
        String id = request.id();
        try {
            IndexResponse response = this.restHighLevelClient.index(request, RequestOptions.DEFAULT);
            DocWriteResponse.Result result = response.getResult();
            if (Objects.equals(result, DocWriteResponse.Result.UPDATED)) {
                log.warn("\u65b0\u589e\u6587\u6863\u5df2\u5b58\u5728\uff0c\u9ed8\u8ba4\u6267\u884c\u4e86\u4fee\u6539\u64cd\u4f5c\uff1a" + JackSonUtil.toJson(data));
                return true;
            }
            log.info("\u7d22\u5f15\u4e3a: {}, id\u4e3a: {} \u65b0\u589e\u6570\u636e\u6210\u529f", (Object)index, (Object)id);
            return Objects.equals(result, DocWriteResponse.Result.CREATED);
        }
        catch (IOException e) {
            log.error(index + " \u6279\u91cf\u4fdd\u5b58\u5931\u8d25", (Throwable)e);
            return false;
        }
    }

    public boolean batchSaveWithRecord(String index, List<Map<String, Object>> recordList) {
        BulkRequest request = new BulkRequest();
        request.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        recordList.forEach(record -> request.add(new IndexRequest(index).source(record)));
        try {
            BulkResponse bulk = this.restHighLevelClient.bulk(request, RequestOptions.DEFAULT);
            return !bulk.hasFailures();
        }
        catch (IOException e) {
            log.error(index + " \u6279\u91cf\u4fdd\u5b58\u5931\u8d25", (Throwable)e);
            return false;
        }
    }

    public boolean batchSave(String index, List<Map<String, Object>> mapList) {
        BulkRequest request = new BulkRequest();
        mapList.forEach(record -> request.add(new IndexRequest(index).source(this.formatMap((Map<String, Object>)record))));
        try {
            BulkResponse bulk = this.restHighLevelClient.bulk(request, RequestOptions.DEFAULT);
            return !bulk.hasFailures();
        }
        catch (IOException e) {
            log.error(index + " \u6279\u91cf\u4fdd\u5b58\u5931\u8d25", (Throwable)e);
            return false;
        }
    }

    public boolean batchSaveByPkField(String index, List<Map<String, Object>> mapList) {
        return this.batchSaveByPkField(index, PK_FIELD_NAME, mapList);
    }

    public boolean batchSaveByPkField(String index, String pkFieldName, List<Map<String, Object>> mapList) {
        BulkRequest request = new BulkRequest();
        request.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        mapList.forEach(map -> {
            IndexRequest indexRequest = new IndexRequest(index).source(this.formatMap((Map<String, Object>)map));
            if (StrUtil.isNotBlank((CharSequence)pkFieldName)) {
                indexRequest.id(String.valueOf(map.get(pkFieldName)));
            }
            request.add(indexRequest);
        });
        request.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        try {
            BulkResponse bulk = this.restHighLevelClient.bulk(request, RequestOptions.DEFAULT);
            log.info("\u7d22\u5f15\u4e3a: {}, \u6279\u91cf\u65b0\u589e\u6570\u636e\u6761\u6570: {}, {}", new Object[]{index, mapList.size(), !bulk.hasFailures()});
            return !bulk.hasFailures();
        }
        catch (IOException e) {
            log.error(index + " \u6279\u91cf\u4fdd\u5b58\u5931\u8d25", (Throwable)e);
            return false;
        }
    }

    public boolean batchUpdateByPkField(String index, String pkFieldName, List<Map<String, Object>> documentList) {
        BulkRequest bulkRequest = new BulkRequest(index);
        bulkRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        for (Map<String, Object> map : documentList) {
            this.formatMap(map);
            bulkRequest.add(new UpdateRequest(index, String.valueOf(map.get(pkFieldName))).doc(map));
        }
        try {
            BulkResponse response = this.restHighLevelClient.bulk(bulkRequest, RequestOptions.DEFAULT);
            log.info("\u7d22\u5f15\u4e3a: {}, \u6279\u91cf\u4fee\u6539\u6570\u636e\u6570\u636e\u91cf: {}, {}", new Object[]{index, documentList.size(), !response.hasFailures()});
            return !response.hasFailures();
        }
        catch (IOException e) {
            log.error(index + " \u6839\u636e\u4e3b\u952e\u4fee\u6539\u6570\u636e", (Throwable)e);
            return false;
        }
    }

    public long updateWithQuery(String index, QueryBuilder query, Map<String, Object> document) throws Exception {
        UpdateByQueryRequest updateByQueryRequest = new UpdateByQueryRequest(new String[]{index});
        updateByQueryRequest.setQuery(query);
        this.formatMap(document);
        StringBuilder script = new StringBuilder();
        Set<String> keys = document.keySet();
        for (String key : keys) {
            String appendValue = "";
            Object value = this.formatValue(document.get(key));
            appendValue = value instanceof Number ? value.toString() : (value instanceof String ? "'" + value + "'" : (value instanceof List ? JackSonUtil.toJson((Object)value) : value.toString()));
            script.append("ctx._source.").append(key).append("=").append(appendValue).append(";");
        }
        updateByQueryRequest.setScript(new Script(script.toString()));
        BulkByScrollResponse bulkByScrollResponse = this.restHighLevelClient.updateByQuery(updateByQueryRequest, RequestOptions.DEFAULT);
        return bulkByScrollResponse.getTotal();
    }

    public boolean updateByPkField(String index, Map<String, Object> document) {
        return this.updateByPkField(index, PK_FIELD_NAME, document);
    }

    public boolean updateByPkField(final String index, String pkFieldName, Map<String, Object> document) {
        final String id = String.valueOf(document.get(pkFieldName));
        UpdateRequest updateRequest = new UpdateRequest(index, id);
        updateRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        this.formatMap(document);
        updateRequest.doc(document);
        ActionListener<UpdateResponse> listener = new ActionListener<UpdateResponse>(){

            public void onResponse(UpdateResponse updateResponse) {
                log.info("\u7d22\u5f15\u4e3a: {}, id\u4e3a: {} \u4fee\u6539\u6570\u636e\u6210\u529f", (Object)index, (Object)id);
            }

            public void onFailure(Exception e) {
                log.error("\u7d22\u5f15\u4e3a: {}, id\u4e3a: {} \u4fee\u6539\u6570\u636e\u5931\u8d25, \u5f02\u5e38\u4fe1\u606f: {}", new Object[]{index, id, e.getMessage()});
            }
        };
        this.restHighLevelClient.updateAsync(updateRequest, RequestOptions.DEFAULT, (ActionListener)listener);
        return true;
    }

    public boolean updateById(String index, String id, Map<String, Object> document) {
        UpdateRequest updateRequest = new UpdateRequest(index, id);
        updateRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        this.formatMap(document);
        updateRequest.doc(document);
        try {
            UpdateResponse response = this.restHighLevelClient.update(updateRequest, RequestOptions.DEFAULT);
            log.info("\u7d22\u5f15\u4e3a: {}, id\u4e3a: {} \u4fee\u6539\u6570\u636e\u6210\u529f", (Object)index, (Object)id);
            return Objects.equals(response.getResult(), DocWriteResponse.Result.UPDATED);
        }
        catch (IOException e) {
            log.error(index + " \u6839\u636e\u4e3b\u952e\u4fee\u6539\u6570\u636e", (Throwable)e);
            return false;
        }
    }

    public boolean deleteDataById(String index, String id) {
        try {
            DeleteRequest request = new DeleteRequest(index, id);
            request.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            this.restHighLevelClient.delete(request, RequestOptions.DEFAULT);
            log.info("\u7d22\u5f15\u4e3a: {}, id\u4e3a: {} \u5220\u9664\u6570\u636e\u6210\u529f", (Object)index, (Object)id);
            return true;
        }
        catch (IOException e) {
            log.error("\u7d22\u5f15\u4e3a: " + index + ", id\u4e3a: " + id + " \u5220\u9664\u6570\u636e\u5931\u8d25", (Throwable)e);
            return false;
        }
    }

    public boolean batchDelete(String index, List<String> ids) {
        BulkRequest bulkRequest = new BulkRequest(index);
        bulkRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        if (CollUtil.isEmpty(ids)) {
            return true;
        }
        ids.forEach(id -> bulkRequest.add(new DeleteRequest(index, id)));
        try {
            BulkResponse response = this.restHighLevelClient.bulk(bulkRequest, RequestOptions.DEFAULT);
            log.info("\u7d22\u5f15\u4e3a: {}, \u6279\u91cf\u5220\u9664\u6570\u636e\u6761\u6570: {} \u6210\u529f", (Object)index, (Object)ids.size());
            return !response.hasFailures();
        }
        catch (IOException e) {
            log.error(index + " \u6839\u636e\u4e3b\u952e\u5220\u9664\u6570\u636e\u5f02\u5e38", (Throwable)e);
            return false;
        }
    }

    public ResponseEntity initTest() throws Exception {
        log.info("EsPlugin Init Test ...");
        Request request = new Request("POST", "/_sql?format=json");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("query", (Object)"show tables");
        jsonObject.put("fetch_size", (Object)100);
        String json = jsonObject.toString();
        request.setJsonEntity(json);
        Response response = this.restClient.performRequest(request);
        String resultStr = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
        return (ResponseEntity)JackSonUtil.toObject((String)resultStr, ResponseEntity.class);
    }

    public Long findMaxBuckets() throws Exception {
        Request request = new Request("GET", "/_cluster/settings");
        Response response = this.restClient.performRequest(request);
        String resultStr = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
        return (Long)JSONUtil.parseObj((String)resultStr).getByPath("persistent.search.max_buckets", Long.class);
    }

    public boolean putMaxBuckets(Integer maxBuckets) throws Exception {
        Request request = new Request("PUT", "/_cluster/settings");
        JSONObject json = new JSONObject();
        JSONObject jsonObject = new JSONObject();
        jsonObject.set("search.max_buckets", (Object)maxBuckets);
        json.set("persistent", (Object)jsonObject);
        String jsonStr = json.toString();
        request.setJsonEntity(jsonStr);
        Response response = this.restClient.performRequest(request);
        String resultStr = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
        return (Boolean)JSONUtil.parseObj((String)resultStr).getByPath("acknowledged", Boolean.class);
    }

    public Page<Map<String, Object>> findPageBySql(String tableName, Integer pageNum, Integer pageSize, String sql, List<String> includeFieldList) {
        SearchResponse searchResponse = null;
        try {
            SearchSourceBuilder searchSourceBuilder = this.sqlParser.parse(sql);
            searchSourceBuilder.trackTotalHits(true);
            searchSourceBuilder.from((pageNum - 1) * pageSize);
            searchSourceBuilder.size(pageSize.intValue());
            if (CollUtil.isNotEmpty(includeFieldList)) {
                FetchSourceContext fetchSourceContext = new FetchSourceContext(true, includeFieldList.toArray(new String[0]), Strings.EMPTY_ARRAY);
                searchSourceBuilder.fetchSource(fetchSourceContext);
            }
            log.info("query dsl: " + searchSourceBuilder);
            SearchRequest searchRequest = new SearchRequest(new String[]{tableName});
            searchRequest.source(searchSourceBuilder);
            RequestOptions.Builder builder = RequestOptions.DEFAULT.toBuilder();
            builder.setHttpAsyncResponseConsumerFactory((HttpAsyncResponseConsumerFactory)new HttpAsyncResponseConsumerFactory.HeapBufferedResponseConsumerFactory(1048576000));
            searchResponse = this.restHighLevelClient.search(searchRequest, RequestOptions.DEFAULT);
        }
        catch (Exception e) {
            log.error("sql to dsl fail!", (Throwable)e);
        }
        return this.responseToPage(pageNum, pageSize, searchResponse);
    }

    private Page<Map<String, Object>> responseToPage(Integer pageNum, Integer pageSize, SearchResponse searchResponse) {
        Page recordPage = new Page((long)pageNum.intValue(), (long)pageSize.intValue(), -1L, null);
        if (Objects.isNull(searchResponse)) {
            return recordPage;
        }
        SearchHits hits = searchResponse.getHits();
        int total = Math.toIntExact(hits.getTotalHits().value);
        ArrayList mapList = new ArrayList(pageSize);
        Arrays.stream(hits.getHits()).forEach(hit -> mapList.add(hit.getSourceAsMap()));
        recordPage.setPages((long)((total - 1) / pageSize));
        recordPage.setTotal((long)total);
        recordPage.setCurrent((long)pageNum.intValue());
        recordPage.setCurrent((long)pageSize.intValue());
        recordPage.setRecords(mapList);
        return recordPage;
    }

    public ResponseEntity findBySql(String sql) {
        Request request = new Request("POST", "/_sql?format=json");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("query", (Object)sql);
        jsonObject.put("fetch_size", (Object)MAX_BUCKETS);
        String json = jsonObject.toString();
        request.setJsonEntity(json);
        try {
            Response response = this.restClient.performRequest(request);
            String resultStr = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
            return (ResponseEntity)JackSonUtil.toObject((String)resultStr, ResponseEntity.class);
        }
        catch (Exception e) {
            log.error("\u6267\u884c\u67e5\u8be2\u8bed\u53e5\u5931\u8d25\uff1a" + sql, (Throwable)e);
            return ResponseEntity.EMPTY_OBJ;
        }
    }

    public Number findCountBySql(String sql) {
        Collection<String> tableList = new TableNameParser(sql).tables();
        Optional<String> optional = tableList.stream().findFirst();
        String tableName = "";
        if (optional.isPresent()) {
            tableName = optional.get().replaceAll("\"", "");
        }
        CountRequest countRequest = new CountRequest();
        try {
            SearchSourceBuilder searchSourceBuilder = this.sqlParser.parse(sql);
            if (StrUtil.isNotBlank((CharSequence)tableName)) {
                countRequest.indices(new String[]{tableName});
            }
            countRequest.source(searchSourceBuilder);
            CountResponse response = this.restHighLevelClient.count(countRequest, RequestOptions.DEFAULT);
            long count = response.getCount();
            return new Long(count).intValue();
        }
        catch (Exception e) {
            log.error("\u6267\u884c\u67e5\u8be2\u8bed\u53e5\u5931\u8d25\uff1a" + sql, (Throwable)e);
            return 0;
        }
    }

    private String processDateStr(long dateLong) {
        return DateUtil.formatDate((java.util.Date)new java.util.Date(dateLong));
    }

    private java.util.Date processDate(long dateLong) {
        return DateUtil.beginOfDay((java.util.Date)new java.util.Date(dateLong)).toJdkDate();
    }

    public Map<String, Object> findById(String index, String id) throws IOException {
        return this.findById(index, id, null);
    }

    public Map<String, Object> findById(String index, String id, String fields) throws IOException {
        GetRequest request = new GetRequest(index, id);
        if (StrUtil.isNotEmpty((CharSequence)fields)) {
            request.fetchSourceContext(new FetchSourceContext(true, fields.split(","), Strings.EMPTY_ARRAY));
        }
        GetResponse response = this.restHighLevelClient.get(request, RequestOptions.DEFAULT);
        Map map = response.getSource();
        map.put("_id", response.getId());
        return map;
    }

    public String getMappings(String indexName) throws IOException {
        GetMappingsRequest request = new GetMappingsRequest().indices(new String[]{indexName});
        GetMappingsResponse response = this.restHighLevelClient.indices().getMapping(request, RequestOptions.DEFAULT);
        Map mappingMap = response.mappings();
        MappingMetadata indexMapping = (MappingMetadata)mappingMap.get(indexName);
        Map mapping = indexMapping.sourceAsMap();
        return JackSonUtil.toJson((Object)mapping);
    }

    public boolean createMappings(String indexName, String mappings) throws IOException {
        CreateIndexRequest createIndexRequest = new CreateIndexRequest(indexName);
        createIndexRequest.settings(Settings.builder().put("number_of_shards", "1").put("number_of_replicas", "0"));
        createIndexRequest.mapping(mappings, XContentType.JSON);
        createIndexRequest.setTimeout(TimeValue.timeValueMinutes((long)2L));
        createIndexRequest.setMasterTimeout(TimeValue.timeValueMinutes((long)1L));
        createIndexRequest.waitForActiveShards(ActiveShardCount.from((int)2));
        createIndexRequest.waitForActiveShards(ActiveShardCount.DEFAULT);
        CreateIndexResponse createIndexResponse = this.restHighLevelClient.indices().create(createIndexRequest, RequestOptions.DEFAULT);
        boolean acknowledged = createIndexResponse.isAcknowledged();
        boolean shardsAcknowledged = createIndexResponse.isShardsAcknowledged();
        return acknowledged;
    }

    public boolean createMappings(String indexName, XContentBuilder contentBuilder) throws IOException {
        CreateIndexRequest createIndexRequest = new CreateIndexRequest(indexName);
        createIndexRequest.settings(Settings.builder().put("number_of_shards", "1").put("number_of_replicas", "0"));
        createIndexRequest.mapping(contentBuilder);
        createIndexRequest.setTimeout(TimeValue.timeValueMinutes((long)2L));
        createIndexRequest.setMasterTimeout(TimeValue.timeValueMinutes((long)1L));
        createIndexRequest.waitForActiveShards(ActiveShardCount.from((int)2));
        createIndexRequest.waitForActiveShards(ActiveShardCount.DEFAULT);
        CreateIndexResponse createIndexResponse = this.restHighLevelClient.indices().create(createIndexRequest, RequestOptions.DEFAULT);
        boolean acknowledged = createIndexResponse.isAcknowledged();
        boolean shardsAcknowledged = createIndexResponse.isShardsAcknowledged();
        return acknowledged;
    }

    public boolean putMappings(String indexName, String mappings) throws IOException {
        PutMappingRequest request = new PutMappingRequest(new String[]{indexName}).source(mappings, XContentType.JSON);
        AcknowledgedResponse acknowledgedResponse = this.restHighLevelClient.indices().putMapping(request, RequestOptions.DEFAULT);
        return acknowledgedResponse.isAcknowledged();
    }

    public boolean putMappings(String indexName, XContentBuilder contentBuilder) throws IOException {
        PutMappingRequest request = new PutMappingRequest(new String[]{indexName}).source(contentBuilder);
        AcknowledgedResponse acknowledgedResponse = this.restHighLevelClient.indices().putMapping(request, RequestOptions.DEFAULT);
        return acknowledgedResponse.isAcknowledged();
    }

    private /* synthetic */ HttpAsyncClientBuilder lambda$init$0(CredentialsProvider credentialsProvider, HttpAsyncClientBuilder httpClientBuilder) {
        return httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider).setMaxConnTotal(this.properties.getMaxConnectNum().intValue()).setMaxConnPerRoute(this.properties.getMaxConnectPerRoute().intValue());
    }
}

