/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.elasticsearch.parser;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLOrderBy;
import com.alibaba.druid.sql.ast.SQLOrderingSpecification;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLBetweenExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLInListExpr;
import com.alibaba.druid.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectQuery;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.efficient.elasticsearch.properties.ElasticSearchProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RegexpQueryBuilder;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.index.query.WildcardQueryBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;

public class SqlParser {
    private static final String DB_TYPE = "postgresql";
    private final String DOT = ".";
    private final String QUOTES = "\"";
    private ElasticSearchProperties properties;

    public SqlParser(ElasticSearchProperties properties) {
        this.properties = properties;
    }

    public SearchSourceBuilder parse(String sql) throws Exception {
        if (Objects.isNull(sql)) {
            throw new IllegalArgumentException("\u8f93\u5165 SQL \u8bed\u53e5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List stmtList = SQLUtils.parseStatements((String)(sql = sql.trim().toLowerCase()), (String)DB_TYPE);
        if (stmtList.size() != 1) {
            throw new IllegalArgumentException("\u5fc5\u987b\u8f93\u5165\u4e00\u53e5\u5b8c\u6574\u7684\u67e5\u8be2\u8bed\u53e5");
        }
        SQLStatement stmt = (SQLStatement)stmtList.get(0);
        if (!(stmt instanceof SQLSelectStatement)) {
            throw new IllegalArgumentException("\u8f93\u5165\u8bed\u53e5\u987b\u4e3aSelect\u8bed\u53e5");
        }
        SQLSelectStatement sqlSelectStatement = (SQLSelectStatement)stmt;
        SQLSelectQuery sqlSelectQuery = sqlSelectStatement.getSelect().getQuery();
        SQLSelectQueryBlock sqlSelectQueryBlock = (SQLSelectQueryBlock)sqlSelectQuery;
        SQLExpr whereExpr = sqlSelectQueryBlock.getWhere();
        BoolQueryBuilder bridge = QueryBuilders.boolQuery();
        QueryBuilder whereBuilder = this.whereHelper(whereExpr);
        bridge.must(whereBuilder);
        SearchSourceBuilder builder = new SearchSourceBuilder();
        SQLOrderBy orderByExpr = sqlSelectQueryBlock.getOrderBy();
        if (Objects.nonNull(orderByExpr)) {
            this.orderByHelper(orderByExpr, builder);
        }
        builder.query((QueryBuilder)bridge);
        return builder;
    }

    private void orderByHelper(SQLOrderBy orderByExpr, SearchSourceBuilder builder) {
        List orderByList = orderByExpr.getItems();
        for (SQLSelectOrderByItem sqlSelectOrderByItem : orderByList) {
            if (sqlSelectOrderByItem.getType() == null) {
                sqlSelectOrderByItem.setType(SQLOrderingSpecification.ASC);
            }
            String orderByColumn = sqlSelectOrderByItem.getExpr().toString();
            builder.sort(orderByColumn, sqlSelectOrderByItem.getType().equals((Object)SQLOrderingSpecification.ASC) ? SortOrder.ASC : SortOrder.DESC);
        }
    }

    private QueryBuilder whereHelper(SQLExpr expr) throws Exception {
        BoolQueryBuilder bridge = QueryBuilders.boolQuery();
        if (Objects.isNull(expr)) {
            return bridge;
        }
        if (expr instanceof SQLBinaryOpExpr) {
            SQLBinaryOperator operator = ((SQLBinaryOpExpr)expr).getOperator();
            if (operator.isLogical()) {
                return this.handleLogicalExpr(expr);
            }
            if (operator.isRelational()) {
                return this.handleRelationalExpr(expr);
            }
        } else {
            if (expr instanceof SQLBetweenExpr) {
                SQLBetweenExpr between = (SQLBetweenExpr)expr;
                boolean isNotBetween = between.isNot();
                String testExpr = this.formatSqlField(between.testExpr.toString());
                Object fromStr = this.formatSqlValue(between.beginExpr.toString());
                Object toStr = this.formatSqlValue(between.endExpr.toString());
                if (isNotBetween) {
                    bridge.must((QueryBuilder)QueryBuilders.rangeQuery((String)testExpr).lt(fromStr).gt(toStr));
                } else {
                    bridge.must((QueryBuilder)QueryBuilders.rangeQuery((String)testExpr).gte(fromStr).lte(toStr));
                }
                return bridge;
            }
            if (expr instanceof SQLInListExpr) {
                SQLInListExpr siExpr = (SQLInListExpr)expr;
                boolean isNotIn = siExpr.isNot();
                String leftSide = this.formatSqlField(siExpr.getExpr().toString());
                List inSqlList = siExpr.getTargetList();
                ArrayList<Object> inList = new ArrayList<Object>();
                for (SQLExpr in : inSqlList) {
                    Object str = this.formatSqlValue(in.toString());
                    inList.add(str);
                }
                if (isNotIn) {
                    bridge.mustNot((QueryBuilder)QueryBuilders.termsQuery((String)leftSide, inList));
                } else {
                    bridge.must((QueryBuilder)QueryBuilders.termsQuery((String)leftSide, inList));
                }
                return bridge;
            }
        }
        return bridge;
    }

    private QueryBuilder handleLogicalExpr(SQLExpr expr) throws Exception {
        BoolQueryBuilder bridge = QueryBuilders.boolQuery();
        SQLBinaryOperator operator = ((SQLBinaryOpExpr)expr).getOperator();
        SQLExpr leftExpr = ((SQLBinaryOpExpr)expr).getLeft();
        SQLExpr rightExpr = ((SQLBinaryOpExpr)expr).getRight();
        QueryBuilder leftBridge = this.whereHelper(leftExpr);
        QueryBuilder rightBridge = this.whereHelper(rightExpr);
        if (operator.equals((Object)SQLBinaryOperator.BooleanAnd)) {
            bridge.must(leftBridge).must(rightBridge);
        } else if (operator.equals((Object)SQLBinaryOperator.BooleanOr)) {
            bridge.should(leftBridge).should(rightBridge);
        }
        return bridge;
    }

    private QueryBuilder handleRelationalExpr(SQLExpr expr) {
        BoolQueryBuilder queryBuilder;
        SQLExpr leftExpr = ((SQLBinaryOpExpr)expr).getLeft();
        if (Objects.isNull(leftExpr)) {
            throw new NullPointerException("\u8868\u8fbe\u5f0f\u5de6\u4fa7\u4e0d\u5f97\u4e3a\u7a7a");
        }
        String leftExprStr = this.formatSqlField(leftExpr.toString());
        Object rightExprStr = this.formatSqlValue(((SQLBinaryOpExpr)expr).getRight().toString());
        SQLBinaryOperator operator = ((SQLBinaryOpExpr)expr).getOperator();
        switch (operator) {
            case GreaterThanOrEqual: {
                queryBuilder = QueryBuilders.rangeQuery((String)leftExprStr).gte(rightExprStr);
                break;
            }
            case LessThanOrEqual: {
                queryBuilder = QueryBuilders.rangeQuery((String)leftExprStr).lte(rightExprStr);
                break;
            }
            case Equality: {
                queryBuilder = QueryBuilders.boolQuery();
                TermQueryBuilder eqCond = QueryBuilders.termQuery((String)leftExprStr, (Object)rightExprStr);
                queryBuilder.must((QueryBuilder)eqCond);
                break;
            }
            case GreaterThan: {
                queryBuilder = QueryBuilders.rangeQuery((String)leftExprStr).gt(rightExprStr);
                break;
            }
            case LessThan: {
                queryBuilder = QueryBuilders.rangeQuery((String)leftExprStr).lt(rightExprStr);
                break;
            }
            case LessThanOrGreater: {
                queryBuilder = QueryBuilders.boolQuery();
                TermQueryBuilder notEq = QueryBuilders.termQuery((String)leftExprStr, (Object)rightExprStr);
                queryBuilder.mustNot((QueryBuilder)notEq);
                break;
            }
            case NotEqual: {
                queryBuilder = QueryBuilders.boolQuery();
                if (StrUtil.isBlank((CharSequence)String.valueOf(rightExprStr))) {
                    queryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)leftExprStr, (String)"*"));
                    break;
                }
                TermQueryBuilder notEqCond = QueryBuilders.termQuery((String)leftExprStr, (Object)rightExprStr);
                queryBuilder.mustNot((QueryBuilder)notEqCond);
                break;
            }
            case RegExp: {
                queryBuilder = QueryBuilders.boolQuery();
                RegexpQueryBuilder regCond = QueryBuilders.regexpQuery((String)leftExprStr, (String)String.valueOf(rightExprStr));
                queryBuilder.mustNot((QueryBuilder)regCond);
                break;
            }
            case NotRegExp: {
                queryBuilder = QueryBuilders.boolQuery();
                RegexpQueryBuilder notRegCond = QueryBuilders.regexpQuery((String)leftExprStr, (String)String.valueOf(rightExprStr));
                queryBuilder.mustNot((QueryBuilder)notRegCond);
                break;
            }
            case Like: {
                String valueOf = String.valueOf(rightExprStr).replace("%", "*");
                queryBuilder = QueryBuilders.boolQuery();
                WildcardQueryBuilder wildcardQuery = QueryBuilders.wildcardQuery((String)leftExprStr, (String)valueOf);
                queryBuilder.must((QueryBuilder)wildcardQuery);
                break;
            }
            case NotLike: {
                String valueOf = String.valueOf(rightExprStr).replace("%", "*");
                queryBuilder = QueryBuilders.boolQuery();
                WildcardQueryBuilder wildcardQuery = QueryBuilders.wildcardQuery((String)leftExprStr, (String)valueOf);
                queryBuilder.mustNot((QueryBuilder)wildcardQuery);
                break;
            }
            case Is: {
                queryBuilder = QueryBuilders.boolQuery();
                queryBuilder.mustNot((QueryBuilder)QueryBuilders.existsQuery((String)leftExprStr));
                break;
            }
            case IsNot: {
                queryBuilder = QueryBuilders.boolQuery();
                queryBuilder.must((QueryBuilder)QueryBuilders.existsQuery((String)leftExprStr));
                break;
            }
            default: {
                throw new IllegalArgumentException("\u6682\u4e0d\u652f\u6301\u8be5\u8fd0\u7b97\u7b26!" + operator);
            }
        }
        return queryBuilder;
    }

    private Object formatSqlValue(String sqlExprStr) {
        if (StrUtil.isNotBlank((CharSequence)sqlExprStr)) {
            String replaceAll = sqlExprStr.replaceAll("'", "");
            if (StrUtil.isBlank((CharSequence)replaceAll)) {
                return "";
            }
            if (replaceAll.contains("TIMESTAMP")) {
                replaceAll = replaceAll.replaceAll("TIMESTAMP", "").trim();
                if (this.properties.isDateToTimestamp()) {
                    return DateUtil.parse((CharSequence)replaceAll, (String)"yyyy-MM-dd HH:mm:ss.S").getTime();
                }
                return replaceAll;
            }
            return replaceAll;
        }
        return sqlExprStr;
    }

    private String formatSqlField(String sqlExprStr) {
        if (StrUtil.isNotBlank((CharSequence)sqlExprStr)) {
            if (sqlExprStr.contains("\"")) {
                sqlExprStr = sqlExprStr.replaceAll("\"", "");
            }
            if (sqlExprStr.contains(".")) {
                String[] splits = sqlExprStr.split("\\.");
                if (splits.length == 2) {
                    return splits[1];
                }
                return sqlExprStr;
            }
            return sqlExprStr;
        }
        return sqlExprStr;
    }
}

