/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.elasticsearch.config;

import com.efficient.elasticsearch.properties.ElasticSearchProperties;
import com.efficient.elasticsearch.service.ElasticSearchService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={ElasticSearchProperties.class})
public class ElasticSearchConfig {
    private static final Logger log = LoggerFactory.getLogger(ElasticSearchConfig.class);
    @Autowired
    private ElasticSearchProperties properties;

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(name={"com.efficient.elasticsearch.enable"}, havingValue="true", matchIfMissing=true)
    public ElasticSearchService createElasticSearchService() {
        ElasticSearchService elasticSearchService = new ElasticSearchService();
        elasticSearchService.init(this.properties);
        log.info("load ElasticSearch  Service success !");
        return elasticSearchService;
    }
}

