/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.file.controller;

import cn.hutool.core.util.StrUtil;
import com.efficient.file.api.FileService;
import com.efficient.file.constant.FileResultEnum;
import com.efficient.file.model.dto.DownloadVO;
import com.efficient.file.model.vo.FileVO;
import com.sjr.common.permission.Permission;
import com.sjr.common.result.Result;
import com.sjr.common.result.ResultConstant;
import com.sjr.common.util.JackSonUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/file"})
@Validated
@Api(tags={"\u6587\u4ef6\u64cd\u4f5c"})
@Permission
public class FileController {
    @Autowired
    private FileService fileService;
    @Autowired
    private HttpServletResponse response;

    @PostMapping(value={"/upload"})
    @ApiOperation(value="\u4e0a\u4f20", response=Result.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="file", value="\u6587\u4ef6\u6807\u8bc6", required=true), @ApiImplicitParam(name="unique", value="\u662f\u5426\u552f\u4e00\u6587\u4ef6\uff0ctrue\u6807\u8bc6\u5220\u9664\u73b0\u6709\u540c\u540d\u6587\u4ef6", defaultValue="false")})
    public Result upload(@RequestParam(value="file") MultipartFile file, @RequestParam(value="unique", required=false) boolean unique) throws Exception {
        if (file.isEmpty() || StrUtil.isBlank((CharSequence)file.getOriginalFilename())) {
            return Result.build((ResultConstant)FileResultEnum.NOT_CHECK_FILE);
        }
        return this.fileService.upload(file, unique);
    }

    @PostMapping(value={"/download"})
    @ApiOperation(value="\u4e0b\u8f7d")
    public void download(@Validated @RequestBody DownloadVO downloadVO) throws Exception {
        FileVO file = this.fileService.getFile(downloadVO);
        if (Objects.isNull(file)) {
            this.response.reset();
            this.response.setCharacterEncoding(StandardCharsets.UTF_8.name());
            this.response.setContentType("application/json;charset=UTF-8");
            this.response.getWriter().println(JackSonUtil.toJson((Object)Result.build((ResultConstant)FileResultEnum.FILE_NOT_EXISTS)));
            this.response.flushBuffer();
            return;
        }
        byte[] bytes = file.getFileContent();
        String fileName = URLEncoder.encode(file.getFileName(), "UTF-8");
        this.response.reset();
        this.response.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
        this.response.addHeader("Content-Length", "" + bytes.length);
        this.response.setContentType("application/octet-stream;charset=UTF-8");
        BufferedOutputStream outputStream = new BufferedOutputStream((OutputStream)this.response.getOutputStream());
        ((OutputStream)outputStream).write(bytes);
        ((OutputStream)outputStream).flush();
        ((OutputStream)outputStream).close();
        this.response.flushBuffer();
    }

    @PostMapping(value={"/delete"})
    @ApiOperation(value="\u4e0b\u8f7d")
    public Result delete(@Validated @RequestBody DownloadVO downloadVO) throws Exception {
        boolean flag = this.fileService.delete(downloadVO.getFileId());
        return flag ? Result.ok() : Result.fail();
    }
}

