/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.file.controller;

import com.efficient.common.permission.Permission;
import com.efficient.common.result.Result;
import com.efficient.file.api.SysFileInfoService;
import com.efficient.file.model.dto.FileBizRelation;
import com.efficient.file.model.entity.SysFileInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.constraints.NotBlank;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/fileInfo"})
@Validated
@Api(tags={"\u6587\u4ef6\u4fe1\u606f\u64cd\u4f5c"})
@Permission
public class SysFileInfoController {
    private static final Logger log = LoggerFactory.getLogger(SysFileInfoController.class);
    @Autowired
    private SysFileInfoService fileInfoService;

    @PostMapping(value={"/saveListByBizId"})
    @ApiOperation(value="\u4fdd\u5b58\u6587\u4ef6\u4e1a\u52a1\u5173\u8054\u6027", response=Boolean.class)
    public Result<Boolean> saveListByBizId(@Validated @RequestBody FileBizRelation dto) {
        boolean saved = this.fileInfoService.saveListByBizId(dto.getFileIdList(), dto.getBizId());
        return saved ? Result.ok() : Result.fail();
    }

    @GetMapping(value={"/findByBizId"})
    @ApiOperation(value="\u6839\u636e\u4e1a\u52a1\u4e3b\u952e\u83b7\u53d6\u5173\u8054\u7684\u6587\u4ef6\u4fe1\u606f", response=Boolean.class)
    public Result<List<SysFileInfo>> findByBizId(@NotBlank(message="bizId \u4e0d\u80fd\u4e3a\u7a7a") @NotBlank(message="bizId \u4e0d\u80fd\u4e3a\u7a7a") String bizId) {
        return Result.ok(this.fileInfoService.findByBizId(bizId));
    }
}

