/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.file.controller;

import cn.hutool.core.util.StrUtil;
import com.efficient.common.result.Result;
import com.efficient.common.result.ResultConstant;
import com.efficient.file.api.FileService;
import com.efficient.file.constant.FileResultEnum;
import com.efficient.file.model.dto.DownloadVO;
import com.efficient.file.model.entity.SysFileInfo;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Objects;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.compress.utils.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/file"})
@Validated
public class FileController {
    @Autowired
    private FileService fileService;
    @Autowired
    private HttpServletResponse response;

    @PostMapping(value={"/upload"})
    public Result upload(@RequestParam(value="file") MultipartFile file, @RequestParam(value="unique", required=false) boolean unique) throws Exception {
        if (file.isEmpty() || StrUtil.isBlank((CharSequence)file.getOriginalFilename())) {
            return Result.build((ResultConstant)FileResultEnum.NOT_CHECK_FILE);
        }
        return this.fileService.upload(file, unique);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/download"})
    public ResponseEntity<byte[]> download(@Validated @RequestBody DownloadVO downloadVO) throws Exception {
        SysFileInfo sysFileInfo = (SysFileInfo)this.fileService.getById((Serializable)((Object)downloadVO.getFileId()));
        ResponseEntity responseEntity = null;
        if (Objects.isNull(sysFileInfo)) {
            return responseEntity;
        }
        ByteArrayOutputStream out = null;
        try (InputStream in = this.fileService.getFile(sysFileInfo);){
            out = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)in, (OutputStream)out);
            byte[] bytes = out.toByteArray();
            HttpHeaders headers = new HttpHeaders();
            headers.add("Content-Disposition", "attachment;filename=" + URLEncoder.encode(sysFileInfo.getFileName(), StandardCharsets.UTF_8.name()));
            headers.setContentLength((long)bytes.length);
            headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
            headers.setAccessControlExposeHeaders(Collections.singletonList("*"));
            responseEntity = new ResponseEntity((Object)bytes, (MultiValueMap)headers, HttpStatus.OK);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return responseEntity;
    }

    @PostMapping(value={"/delete"})
    public Result delete(@Validated @RequestBody DownloadVO downloadVO) throws Exception {
        boolean flag = this.fileService.delete(downloadVO.getFileId());
        return flag ? Result.ok() : Result.fail();
    }
}

