/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.file.service;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.NumberUtil;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.efficient.common.result.Result;
import com.efficient.file.api.FileService;
import com.efficient.file.constant.StoreEnum;
import com.efficient.file.dao.SysFileInfoMapper;
import com.efficient.file.model.dto.DownloadVO;
import com.efficient.file.model.entity.SysFileInfo;
import com.efficient.file.model.vo.FileVO;
import com.efficient.file.properties.FileProperties;
import com.efficient.file.util.PathUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.multipart.MultipartFile;

public class LocalFileServiceImpl
extends ServiceImpl<SysFileInfoMapper, SysFileInfo>
implements FileService {
    private static final Logger log = LoggerFactory.getLogger(LocalFileServiceImpl.class);
    @Autowired
    private FileProperties fileProperties;

    @Override
    public FileProperties getProperties() {
        return this.fileProperties;
    }

    @Override
    public Result upload(MultipartFile multipartFile, boolean unique) throws Exception {
        String fileName;
        File fileExist;
        FileVO fileVo = new FileVO();
        String basePath = this.fileProperties.getLocal().getLocalPath() + "/upload/";
        String originalFilename = multipartFile.getOriginalFilename();
        if (originalFilename.lastIndexOf(".") != -1) {
            String suffix = originalFilename.substring(originalFilename.lastIndexOf("."));
            basePath = basePath + PathUtil.getFileUrlFolder(suffix);
        }
        if (this.fileProperties.getLocal().isAddDatePrefix()) {
            basePath = basePath + DateUtil.format((Date)new Date(), (String)"/yyyy/MM/dd/");
        }
        if (!(fileExist = new File(basePath)).exists()) {
            fileExist.mkdirs();
        }
        if (FileUtil.file((String)basePath, (String)(fileName = originalFilename.replaceAll(" ", ""))).exists()) {
            if (unique) {
                FileUtil.del((File)new File(basePath + File.separator + fileName));
            } else {
                String name;
                int lastIndexOf = fileName.lastIndexOf("-");
                int fileNum = 1;
                String nameDefault = fileName.substring(0, fileName.lastIndexOf(".")) + "-" + fileNum;
                if (lastIndexOf > 0) {
                    String subStr = fileName.substring(lastIndexOf + 1, fileName.lastIndexOf("."));
                    if (NumberUtil.isNumber((CharSequence)subStr)) {
                        fileNum = NumberUtil.binaryToInt((String)subStr) + 1;
                        name = fileName.substring(0, lastIndexOf) + "-" + fileNum;
                    } else {
                        name = nameDefault;
                    }
                } else {
                    name = nameDefault;
                }
                fileName = name + Objects.requireNonNull(fileName).substring(fileName.lastIndexOf("."));
            }
        }
        File realFile = new File(basePath, fileName);
        FileUtil.writeBytes((byte[])multipartFile.getBytes(), (File)realFile);
        fileVo.setFileName(realFile.getName());
        fileVo.setStoreType(StoreEnum.LOCAL.name());
        String fileId = this.saveFileInfo(realFile);
        fileVo.setFileId(fileId);
        return Result.ok((Object)fileVo);
    }

    @Override
    public FileVO getFile(DownloadVO downloadVO) {
        SysFileInfo sysFileInfo = (SysFileInfo)this.getById((Serializable)((Object)downloadVO.getFileId()));
        if (Objects.isNull(sysFileInfo)) {
            return null;
        }
        FileVO fileVO = new FileVO();
        File file = new File(sysFileInfo.getFilePath());
        if (!FileUtil.exist((File)file)) {
            return null;
        }
        fileVO.setFileName(file.getName());
        fileVO.setFileContent(FileUtil.readBytes((File)file));
        return fileVO;
    }

    @Override
    public InputStream getFile(SysFileInfo sysFileInfo) throws Exception {
        if (Objects.isNull(sysFileInfo)) {
            return null;
        }
        File file = new File(sysFileInfo.getFilePath());
        if (!FileUtil.exist((File)file)) {
            return null;
        }
        return new ByteArrayInputStream(FileUtil.readBytes((File)file));
    }

    @Override
    public String saveFileInfo(File file) {
        SysFileInfo sysFileInfo = new SysFileInfo();
        sysFileInfo.setStoreType(StoreEnum.LOCAL.name());
        sysFileInfo.setFileName(file.getName());
        sysFileInfo.setFilePath(file.getAbsolutePath());
        sysFileInfo.setFileSize(FileUtil.size((File)file) / 1024L);
        sysFileInfo.setCreateTime(new Date());
        boolean save = this.save(sysFileInfo);
        return sysFileInfo.getId();
    }

    @Override
    public boolean delete(String fileId) throws Exception {
        SysFileInfo sysFileInfo = (SysFileInfo)this.getById((Serializable)((Object)fileId));
        if (Objects.isNull(sysFileInfo)) {
            return true;
        }
        String filePath = sysFileInfo.getFilePath();
        return this.removeById((Serializable)((Object)fileId)) && FileUtil.del((String)filePath);
    }
}

