/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.file.config;

import com.efficient.file.properties.MinioProperties;
import io.minio.MinioClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={MinioProperties.class})
@ConditionalOnProperty(name={"com.efficient.file.active"}, havingValue="minio")
public class MinioConfig {
    @Autowired
    private MinioProperties minioProperties;

    @Bean
    public MinioClient minioClient() {
        return MinioClient.builder().endpoint(this.minioProperties.getEndpoint()).credentials(this.minioProperties.getAccessKey(), this.minioProperties.getSecretKey()).build();
    }
}

