/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.file.controller;

import cn.hutool.core.net.URLDecoder;
import com.efficient.common.result.Result;
import com.efficient.file.api.SysFileInfoService;
import com.efficient.file.api.VideoService;
import com.efficient.file.config.NonStaticResourceHttpRequestHandler;
import com.efficient.file.model.dto.FileChunkDTO;
import com.efficient.file.model.entity.SysFileInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotBlank;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/video"})
@Validated
@Api(tags={"\u89c6\u9891\u64cd\u4f5c"})
public class VideoController {
    private static final Logger log = LoggerFactory.getLogger(VideoController.class);
    @Autowired
    private NonStaticResourceHttpRequestHandler nonStaticResourceHttpRequestHandler;
    @Autowired
    private HttpServletRequest request;
    @Autowired
    private HttpServletResponse response;
    @Autowired
    private VideoService videoService;
    @Autowired
    private SysFileInfoService sysFileInfoService;

    @PostMapping(value={"/chunkUpload"}, consumes={"multipart/form-data"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="chunkSize", value="\u5206\u5757\u5927\u5c0f,\u5b57\u8282", required=true), @ApiImplicitParam(name="totalChunk", value="\u603b\u5757\u6570\u91cf", required=true), @ApiImplicitParam(name="currChunk", value="\u5f53\u524d\u5757\u6570", required=true), @ApiImplicitParam(name="md5", value="\u6587\u4ef6MD5\u503c", required=true), @ApiImplicitParam(name="file", value="\u6587\u4ef6\u5185\u5bb9", required=true), @ApiImplicitParam(name="module", value="\u6587\u4ef6\u6240\u5c5e\u6a21\u5757", defaultValue="false")})
    public Result chunkUpload(@RequestParam Long chunkSize, @RequestParam Integer totalChunk, @RequestParam Integer currChunk, @RequestParam String md5, @RequestParam(value="module", required=false) String module, @RequestParam MultipartFile file) throws Exception {
        FileChunkDTO fileChunkDTO = new FileChunkDTO();
        fileChunkDTO.setMd5(md5);
        fileChunkDTO.setModule(module);
        fileChunkDTO.setFile(file);
        fileChunkDTO.setCurrChunk(currChunk);
        fileChunkDTO.setChunkSize(chunkSize);
        fileChunkDTO.setTotalSize((long)totalChunk.intValue() * chunkSize);
        fileChunkDTO.setTotalChunk(totalChunk);
        fileChunkDTO.setFilename(file.getOriginalFilename());
        return this.videoService.chunkUpload(fileChunkDTO);
    }

    @PostMapping(value={"/checkFile"})
    public Result checkFile(@RequestParam(value="module", required=false) String module, @RequestParam(value="md5") String md5) throws Exception {
        return this.videoService.checkFile(module, md5);
    }

    @GetMapping(value={"/play"})
    public void play(@NotBlank(message="fileId \u4e0d\u80fd\u4e3a\u7a7a") @RequestParam(value="fileId") @NotBlank(message="fileId \u4e0d\u80fd\u4e3a\u7a7a") String fileId) {
        SysFileInfo sysFileInfo = (SysFileInfo)this.sysFileInfoService.getById((Serializable)((Object)fileId));
        try {
            String path = sysFileInfo.getFilePath();
            File file = new File(path);
            if (file.exists()) {
                this.request.setAttribute("NON-STATIC-FILE", (Object)path);
                this.nonStaticResourceHttpRequestHandler.handleRequest(this.request, this.response);
            } else {
                this.response.setStatus(404);
                this.response.setCharacterEncoding(StandardCharsets.UTF_8.toString());
            }
        }
        catch (Exception e) {
            log.error("\u6587\u4ef6\u8bbf\u95ee\u5931\u8d25", (Throwable)e);
        }
    }

    @GetMapping(value={"/playByPath"})
    public void playByPath(@NotBlank(message="filePath \u4e0d\u80fd\u4e3a\u7a7a") @RequestParam(value="filePath") @NotBlank(message="filePath \u4e0d\u80fd\u4e3a\u7a7a") String filePath) {
        try {
            String decode = URLDecoder.decode((String)filePath, (Charset)StandardCharsets.UTF_8);
            File file = new File(decode);
            if (file.exists()) {
                this.request.setAttribute("NON-STATIC-FILE", (Object)decode);
                this.nonStaticResourceHttpRequestHandler.handleRequest(this.request, this.response);
            } else {
                this.response.setStatus(404);
                this.response.setCharacterEncoding(StandardCharsets.UTF_8.toString());
            }
        }
        catch (Exception e) {
            log.error("\u6587\u4ef6\u8bbf\u95ee\u5931\u8d25", (Throwable)e);
        }
    }
}

