/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.file.service;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.StrUtil;
import com.efficient.common.constant.CommonConstant;
import com.efficient.common.result.Result;
import com.efficient.file.api.SysFileInfoService;
import com.efficient.file.api.VideoService;
import com.efficient.file.constant.StoreEnum;
import com.efficient.file.model.dto.FileChunkDTO;
import com.efficient.file.model.entity.SysFileInfo;
import com.efficient.file.properties.FileProperties;
import java.io.File;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Date;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.DigestUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class VideoServiceImpl
implements VideoService {
    private static final Logger log = LoggerFactory.getLogger(VideoServiceImpl.class);
    @Autowired
    private FileProperties fileProperties;
    @Autowired
    private SysFileInfoService sysFileInfoService;

    @Override
    public Result<SysFileInfo> chunkUpload(FileChunkDTO fileChunkDTO) throws Exception {
        String filename = fileChunkDTO.getFilename();
        String md5 = fileChunkDTO.getMd5();
        Integer totalChunk = fileChunkDTO.getTotalChunk();
        MultipartFile file = fileChunkDTO.getFile();
        Integer currChunk = fileChunkDTO.getCurrChunk();
        Long chunkSize = fileChunkDTO.getChunkSize();
        String basePath = this.fileProperties.getLocal().getLocalPath() + "/upload/" + "/chunk/" + fileChunkDTO.getModule();
        if (this.fileProperties.getLocal().isAddDatePrefix()) {
            basePath = basePath + DateUtil.format((Date)new Date(), (String)"/yyyy/MM/dd/");
        }
        String destFile = String.format("%s\\%s\\%s.%s", basePath, md5, md5, StringUtils.getFilenameExtension((String)filename));
        String confFile = String.format("%s\\%s\\%s.conf", basePath, md5, md5);
        File dir = new File(destFile).getParentFile();
        if (!dir.exists()) {
            dir.mkdirs();
            byte[] bytes = new byte[totalChunk.intValue()];
            Files.write(Paths.get(confFile, new String[0]), bytes, new OpenOption[0]);
        }
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(destFile, "rw");
             RandomAccessFile randomAccessConfFile = new RandomAccessFile(confFile, "rw");
             InputStream inputStream = file.getInputStream();){
            randomAccessFile.seek((long)currChunk.intValue() * chunkSize);
            randomAccessFile.write(IoUtil.readBytes((InputStream)inputStream));
            randomAccessConfFile.seek(currChunk.intValue());
            randomAccessConfFile.write(1);
        }
        SysFileInfo sysFileInfo = this.sysFileInfoService.findByPath(destFile);
        if (Objects.isNull(sysFileInfo)) {
            sysFileInfo = new SysFileInfo();
        }
        sysFileInfo.setStoreType(StoreEnum.LOCAL.name());
        sysFileInfo.setFileName(file.getName());
        sysFileInfo.setFilePath(destFile);
        sysFileInfo.setFileSize((long)totalChunk.intValue() * chunkSize / 1024L);
        sysFileInfo.setCreateTime(new Date());
        sysFileInfo.setMd5(md5);
        Result<String> stringResult = this.checkFile(fileChunkDTO.getModule(), fileChunkDTO.getMd5());
        String data = (String)stringResult.getData();
        if (StrUtil.isNotBlank((CharSequence)data) && !data.contains("0")) {
            sysFileInfo.setIsIntact(CommonConstant.TRUE_INT);
        } else {
            sysFileInfo.setIsIntact(CommonConstant.FALSE_INT);
        }
        this.sysFileInfoService.saveOrUpdate(sysFileInfo);
        return Result.ok((Object)sysFileInfo);
    }

    public Result<String> checkFile(String module, String md5) throws Exception {
        byte[] bytes;
        String uploadPath;
        Path path;
        String basePath = this.fileProperties.getLocal().getLocalPath() + "/upload/" + "/chunk/" + module;
        if (this.fileProperties.getLocal().isAddDatePrefix()) {
            basePath = basePath + DateUtil.format((Date)new Date(), (String)"/yyyy/MM/dd/");
        }
        if (!Files.exists((path = Paths.get(uploadPath = String.format("%s\\%s\\%s.conf", basePath, md5, md5), new String[0])).getParent(), new LinkOption[0])) {
            return Result.ok();
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (byte b : bytes = Files.readAllBytes(path)) {
            stringBuilder.append(String.valueOf(b));
        }
        if (!stringBuilder.toString().contains("0")) {
            File file = new File(String.format("%s\\%s\\", basePath, md5));
            File[] files = file.listFiles();
            int length = files.length;
            if (length < 2) {
                return Result.ok((Object)stringBuilder.toString().replaceAll("1", "0"));
            }
            for (File f : files) {
                if (f.getName().contains("conf")) continue;
                try (InputStream inputStream = Files.newInputStream(f.toPath(), new OpenOption[0]);){
                    String md5pwd = DigestUtils.md5DigestAsHex((InputStream)inputStream);
                    if (md5pwd.equalsIgnoreCase(md5)) continue;
                    Result result = Result.ok((Object)stringBuilder.toString().replaceAll("1", "0"));
                    return result;
                }
            }
        }
        return Result.ok((Object)stringBuilder.toString());
    }
}

