/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.file.service;

import cn.hutool.core.io.FileUtil;
import com.efficient.common.result.Result;
import com.efficient.file.api.FileService;
import com.efficient.file.api.SysFileInfoService;
import com.efficient.file.constant.StoreEnum;
import com.efficient.file.model.dto.DownloadVO;
import com.efficient.file.model.entity.SysFileInfo;
import com.efficient.file.model.vo.FileVO;
import com.efficient.file.properties.FileProperties;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.multipart.MultipartFile;

public class DbFileServiceImpl
implements FileService {
    private static final Logger log = LoggerFactory.getLogger(DbFileServiceImpl.class);
    @Autowired
    private FileProperties fileProperties;
    @Autowired
    private SysFileInfoService fileInfoService;

    @Override
    public Result upload(MultipartFile file, boolean unique, String module, String md5) throws Exception {
        SysFileInfo sysFileInfo = new SysFileInfo();
        sysFileInfo.setStoreType(StoreEnum.DB.name());
        sysFileInfo.setFileName(file.getOriginalFilename());
        sysFileInfo.setFileContent(file.getBytes());
        sysFileInfo.setFileSize(file.getSize() / 1024L);
        sysFileInfo.setCreateTime(new Date());
        sysFileInfo.setMd5(md5);
        this.fileInfoService.save(sysFileInfo);
        FileVO fileVO = new FileVO();
        fileVO.setFileName(sysFileInfo.getFileName());
        fileVO.setStoreType(StoreEnum.DB.name());
        fileVO.setFileId(sysFileInfo.getId());
        return Result.ok((Object)fileVO);
    }

    @Override
    public FileVO getFile(DownloadVO downloadVO) {
        SysFileInfo sysFileInfo = (SysFileInfo)this.fileInfoService.getById((Serializable)((Object)downloadVO.getFileId()));
        if (Objects.isNull(sysFileInfo)) {
            return null;
        }
        FileVO vo = new FileVO();
        vo.setFileName(sysFileInfo.getFileName());
        vo.setFileContent(sysFileInfo.getFileContent());
        return vo;
    }

    @Override
    public InputStream getFile(SysFileInfo sysFileInfo) throws Exception {
        if (Objects.isNull(sysFileInfo)) {
            return null;
        }
        return new ByteArrayInputStream(sysFileInfo.getFileContent());
    }

    @Override
    public FileProperties getProperties() {
        return this.fileProperties;
    }

    @Override
    public String saveFileInfo(File file, String md5) {
        SysFileInfo sysFileInfo = new SysFileInfo();
        sysFileInfo.setStoreType(StoreEnum.DB.name());
        sysFileInfo.setFileName(file.getName());
        sysFileInfo.setFileContent(FileUtil.readBytes((File)file));
        sysFileInfo.setFileSize(FileUtil.size((File)file) / 1024L);
        sysFileInfo.setCreateTime(new Date());
        this.fileInfoService.save(sysFileInfo);
        return sysFileInfo.getId();
    }

    @Override
    public boolean delete(String fileId) throws Exception {
        SysFileInfo sysFileInfo = (SysFileInfo)this.fileInfoService.getById((Serializable)((Object)fileId));
        if (Objects.isNull(sysFileInfo)) {
            return true;
        }
        return this.fileInfoService.removeById((Serializable)((Object)fileId));
    }
}

