/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.file.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class FileMd5Util {
    private static final Logger log = LoggerFactory.getLogger(FileMd5Util.class);

    public static String calculateMD5(String filePath) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            try (InputStream is = Files.newInputStream(Paths.get(filePath, new String[0]), new OpenOption[0]);){
                int read;
                byte[] buffer = new byte[8192];
                while ((read = is.read(buffer)) > 0) {
                    md.update(buffer, 0, read);
                }
            }
            byte[] md5 = md.digest();
            StringBuilder result = new StringBuilder();
            for (byte b : md5) {
                result.append(String.format("%02x", b));
            }
            return result.toString();
        }
        catch (IOException | NoSuchAlgorithmException e) {
            log.error("\u8ba1\u7b97\u6587\u4ef6md5\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    public static String calculateMD5(MultipartFile file) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            try (InputStream is = file.getInputStream();){
                int read;
                byte[] buffer = new byte[8192];
                while ((read = is.read(buffer)) > 0) {
                    md.update(buffer, 0, read);
                }
            }
            byte[] md5 = md.digest();
            StringBuilder result = new StringBuilder();
            for (byte b : md5) {
                result.append(String.format("%02x", b));
            }
            return result.toString();
        }
        catch (IOException | NoSuchAlgorithmException e) {
            log.error("\u8ba1\u7b97\u6587\u4ef6md5\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    public static String getMD5ByApacheCommonsCodec(String filePath) {
        try {
            return DigestUtils.md5Hex((InputStream)Files.newInputStream(Paths.get(filePath, new String[0]), new OpenOption[0]));
        }
        catch (IOException e) {
            log.error("\u8ba1\u7b97\u6587\u4ef6md5\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getMD5ByApacheCommonsCodec(MultipartFile file) {
        try (InputStream inputStream = file.getInputStream();){
            String string = DigestUtils.md5Hex((InputStream)inputStream);
            return string;
        }
        catch (IOException e) {
            log.error("\u8ba1\u7b97\u6587\u4ef6md5\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getMD5ByNIO(String filePath) {
        try {
            Path path = new File(filePath).toPath();
            try (InputStream is = Files.newInputStream(path, StandardOpenOption.READ);){
                int read;
                MessageDigest md = MessageDigest.getInstance("MD5");
                byte[] buffer = new byte[8192];
                while ((read = is.read(buffer)) > 0) {
                    md.update(buffer, 0, read);
                }
                byte[] md5 = md.digest();
                StringBuilder result = new StringBuilder();
                for (byte b : md5) {
                    result.append(String.format("%02x", b));
                }
                String string = result.toString();
                return string;
            }
        }
        catch (IOException | NoSuchAlgorithmException e) {
            log.error("\u8ba1\u7b97\u6587\u4ef6md5\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }
}

