/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.file.controller;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import com.efficient.common.permission.Permission;
import com.efficient.common.result.Result;
import com.efficient.common.result.ResultConstant;
import com.efficient.common.validate.Common1Group;
import com.efficient.common.validate.Common2Group;
import com.efficient.file.api.FileService;
import com.efficient.file.api.SysFileInfoService;
import com.efficient.file.constant.FileResultEnum;
import com.efficient.file.model.dto.DownloadVO;
import com.efficient.file.model.entity.SysFileInfo;
import com.efficient.file.util.FileMd5Util;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collections;
import java.util.Objects;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.compress.utils.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/file"})
@Validated
@Api(tags={"\u6587\u4ef6\u64cd\u4f5c"})
@Permission
public class FileController {
    private static final Logger log = LoggerFactory.getLogger(FileController.class);
    @Autowired
    private FileService fileService;
    @Autowired
    private SysFileInfoService sysFileInfoService;
    @Autowired
    private HttpServletResponse response;

    @PostMapping(value={"/upload"})
    @ApiOperation(value="\u4e0a\u4f20", response=Result.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="file", value="\u6587\u4ef6\u6807\u8bc6", required=true), @ApiImplicitParam(name="unique", value="\u662f\u5426\u552f\u4e00\u6587\u4ef6\uff0ctrue\u6807\u8bc6\u5220\u9664\u73b0\u6709\u540c\u540d\u6587\u4ef6", defaultValue="false"), @ApiImplicitParam(name="module", value="\u6587\u4ef6\u6240\u5c5e\u6a21\u5757", defaultValue="false")})
    public Result upload(@RequestParam(value="file") MultipartFile file, @RequestParam(value="unique", required=false) boolean unique, @RequestParam(value="module", required=false) String module, @RequestParam(value="remark", required=false) String remark) throws Exception {
        if (file.isEmpty() || StrUtil.isBlank((CharSequence)file.getOriginalFilename())) {
            return Result.build((ResultConstant)FileResultEnum.NOT_CHECK_FILE);
        }
        String md5 = FileMd5Util.getMD5ByApacheCommonsCodec(file);
        return this.fileService.upload(file, unique, module, md5, remark);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/download"})
    @ApiOperation(value="\u6839\u636eId\u4e0b\u8f7d")
    public ResponseEntity<byte[]> download(@Validated(value={Common1Group.class}) @RequestBody DownloadVO downloadVO) throws Exception {
        SysFileInfo sysFileInfo = (SysFileInfo)this.sysFileInfoService.getById((Serializable)((Object)downloadVO.getFileId()));
        ResponseEntity responseEntity = null;
        if (Objects.isNull(sysFileInfo)) {
            return responseEntity;
        }
        ByteArrayOutputStream out = null;
        try (InputStream in = this.fileService.getFile(sysFileInfo);){
            out = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)in, (OutputStream)out);
            byte[] bytes = out.toByteArray();
            HttpHeaders headers = new HttpHeaders();
            headers.add("Content-Disposition", "attachment;filename=" + URLEncoder.encode(sysFileInfo.getFileName(), StandardCharsets.UTF_8.name()));
            headers.setContentLength((long)bytes.length);
            headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
            headers.setAccessControlExposeHeaders(Collections.singletonList("*"));
            responseEntity = new ResponseEntity((Object)bytes, (MultiValueMap)headers, HttpStatus.OK);
        }
        catch (Exception e) {
            log.error("\u6587\u4ef6\u4e0b\u8f7d\u5f02\u5e38\uff1a", (Throwable)e);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                log.error("\u6587\u4ef6\u4e0b\u8f7d-\u5173\u95ed\u6587\u4ef6\u6d41\u5f02\u5e38\uff1a", (Throwable)e);
            }
        }
        return responseEntity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/downloadByPath"})
    @ApiOperation(value="\u6839\u636e\u8def\u5f84\u4e0b\u8f7d")
    public ResponseEntity<byte[]> downloadByPath(@Validated(value={Common2Group.class}) @RequestBody DownloadVO downloadVO) throws Exception {
        String filePath = downloadVO.getFilePath();
        ResponseEntity responseEntity = null;
        if (StrUtil.isBlank((CharSequence)filePath)) {
            return responseEntity;
        }
        File file = new File(filePath);
        if (!file.exists()) {
            return responseEntity;
        }
        ByteArrayOutputStream out = null;
        try (InputStream in = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            out = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)in, (OutputStream)out);
            byte[] bytes = out.toByteArray();
            HttpHeaders headers = new HttpHeaders();
            headers.add("Content-Disposition", "attachment;filename=" + URLEncoder.encode(FileUtil.getName((String)filePath), StandardCharsets.UTF_8.name()));
            headers.setContentLength((long)bytes.length);
            headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
            headers.setAccessControlExposeHeaders(Collections.singletonList("*"));
            responseEntity = new ResponseEntity((Object)bytes, (MultiValueMap)headers, HttpStatus.OK);
        }
        catch (Exception e) {
            log.error("\u6587\u4ef6\u4e0b\u8f7d\u5f02\u5e38\uff1a", (Throwable)e);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                log.error("\u6587\u4ef6\u4e0b\u8f7d-\u5173\u95ed\u6587\u4ef6\u6d41\u5f02\u5e38\uff1a", (Throwable)e);
            }
        }
        return responseEntity;
    }

    @PostMapping(value={"/delete"})
    public Result delete(@Validated @RequestBody DownloadVO downloadVO) throws Exception {
        boolean flag = this.fileService.delete(downloadVO.getFileId());
        return flag ? Result.ok() : Result.fail();
    }
}

