/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.file.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.efficient.file.api.SysFileInfoService;
import com.efficient.file.dao.SysFileInfoMapper;
import com.efficient.file.model.entity.SysFileInfo;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysFileInfoServiceImpl
extends ServiceImpl<SysFileInfoMapper, SysFileInfo>
implements SysFileInfoService {
    @Autowired
    private SysFileInfoMapper fileInfoMapper;

    @Override
    public SysFileInfo findByPath(String destFile) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysFileInfo::getFilePath, (Object)destFile);
        queryWrapper.orderByAsc(SysFileInfo::getId);
        queryWrapper.last(" limit 1");
        return (SysFileInfo)this.fileInfoMapper.selectOne((Wrapper)queryWrapper);
    }

    @Override
    public SysFileInfo findByPathAndMd5(String destFile, String md5) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysFileInfo::getFilePath, (Object)destFile);
        queryWrapper.eq(SysFileInfo::getMd5, (Object)md5);
        queryWrapper.orderByAsc(SysFileInfo::getId);
        queryWrapper.last(" limit 1");
        return (SysFileInfo)this.fileInfoMapper.selectOne((Wrapper)queryWrapper);
    }

    @Override
    public boolean saveListByBizId(List<String> fileIdList, String bizId) {
        if (CollUtil.isEmpty(fileIdList) || StrUtil.isBlank((CharSequence)bizId)) {
            return false;
        }
        this.fileInfoMapper.deleteByFIleIdListAndBizId(fileIdList, bizId);
        this.fileInfoMapper.setBizIdWithFileIdList(fileIdList, bizId);
        return true;
    }

    @Override
    public List<SysFileInfo> findByBizId(String bizId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper(SysFileInfo.class);
        queryWrapper.select(new SFunction[]{SysFileInfo::getId, SysFileInfo::getBizId, SysFileInfo::getFileName, SysFileInfo::getFileSize, SysFileInfo::getRemark});
        queryWrapper.eq(SysFileInfo::getBizId, (Object)bizId);
        queryWrapper.orderByAsc(SysFileInfo::getCreateTime);
        return this.list((Wrapper)queryWrapper);
    }
}

