/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.file.service;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import com.efficient.common.result.Result;
import com.efficient.file.api.FileService;
import com.efficient.file.api.SysFileInfoService;
import com.efficient.file.constant.FileConstant;
import com.efficient.file.constant.StoreEnum;
import com.efficient.file.model.dto.DownloadVO;
import com.efficient.file.model.entity.SysFileInfo;
import com.efficient.file.model.vo.FileVO;
import com.efficient.file.properties.FileProperties;
import com.efficient.file.util.FileMd5Util;
import com.efficient.file.util.PathUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.multipart.MultipartFile;

public class LocalFileServiceImpl
implements FileService {
    private static final Logger log = LoggerFactory.getLogger(LocalFileServiceImpl.class);
    @Autowired
    private FileProperties fileProperties;
    @Autowired
    private SysFileInfoService fileInfoService;

    @Override
    public Result<FileVO> upload(MultipartFile multipartFile, boolean unique, String module, String md5, String remark) throws Exception {
        File fileExist;
        FileVO fileVo = new FileVO();
        if (StrUtil.isBlank((CharSequence)module)) {
            module = "";
        }
        String basePath = this.fileProperties.getLocal().getLocalPath() + "/upload/" + module;
        String originalFilename = multipartFile.getOriginalFilename();
        if (originalFilename.lastIndexOf(".") != -1) {
            String suffix = originalFilename.substring(originalFilename.lastIndexOf("."));
            basePath = basePath + PathUtil.getFileUrlFolder(suffix);
        }
        if (this.fileProperties.getLocal().isAddDatePrefix()) {
            basePath = basePath + DateUtil.format((Date)new Date(), (String)"/yyyy/MM/dd/");
        }
        if (!(fileExist = new File(basePath)).exists()) {
            fileExist.mkdirs();
        }
        String fileName = originalFilename.replaceAll(" ", "");
        if (unique) {
            FileUtil.del((File)new File(basePath + File.separator + fileName));
        }
        int pointIndexOf = fileName.lastIndexOf(".");
        String suffix = fileName.substring(pointIndexOf);
        int fileNum = 1;
        String nameDefault = fileName.substring(0, fileName.lastIndexOf(".")) + "-" + 1 + suffix;
        String name = fileName;
        while (FileUtil.file((String)basePath, (String)name).exists()) {
            int lastIndexOf = name.lastIndexOf("-");
            if (lastIndexOf > 0) {
                String subStr = name.substring(lastIndexOf + 1, name.lastIndexOf("."));
                if (NumberUtil.isNumber((CharSequence)subStr)) {
                    fileNum = Integer.parseInt(subStr) + 1;
                    name = name.substring(0, lastIndexOf) + "-" + fileNum + suffix;
                    continue;
                }
                name = nameDefault;
                continue;
            }
            name = nameDefault;
        }
        fileName = name;
        File realFile = new File(basePath, fileName);
        FileUtil.writeBytes((byte[])multipartFile.getBytes(), (File)realFile);
        fileVo.setFileName(realFile.getName());
        fileVo.setStoreType(StoreEnum.LOCAL.name());
        SysFileInfo sysFileInfo = this.saveFileInfo(realFile, md5, remark);
        fileVo.setFileId(sysFileInfo.getId());
        fileVo.setContentType(sysFileInfo.getContentType());
        return Result.ok((Object)fileVo);
    }

    @Override
    public FileVO getFile(DownloadVO downloadVO) {
        SysFileInfo sysFileInfo = (SysFileInfo)this.fileInfoService.getById((Serializable)((Object)downloadVO.getFileId()));
        if (Objects.isNull(sysFileInfo)) {
            return null;
        }
        FileVO fileVO = new FileVO();
        File file = new File(sysFileInfo.getFilePath());
        if (!FileUtil.exist((File)file)) {
            return null;
        }
        fileVO.setFileName(file.getName());
        fileVO.setFileContent(FileUtil.readBytes((File)file));
        return fileVO;
    }

    @Override
    public InputStream getFile(SysFileInfo sysFileInfo) throws Exception {
        if (Objects.isNull(sysFileInfo)) {
            return null;
        }
        File file = new File(sysFileInfo.getFilePath());
        if (!FileUtil.exist((File)file)) {
            return null;
        }
        return new ByteArrayInputStream(FileUtil.readBytes((File)file));
    }

    @Override
    public FileProperties getProperties() {
        return this.fileProperties;
    }

    @Override
    public SysFileInfo saveFileInfo(File file, String md5, String remark) {
        SysFileInfo sysFileInfo = new SysFileInfo();
        sysFileInfo.setStoreType(StoreEnum.LOCAL.name());
        sysFileInfo.setFileName(file.getName());
        sysFileInfo.setFilePath(file.getAbsolutePath());
        sysFileInfo.setFileSize(FileUtil.size((File)file) / (long)FileConstant.KB.intValue());
        sysFileInfo.setCreateTime(new Date());
        if (StrUtil.isBlank((CharSequence)md5)) {
            sysFileInfo.setMd5(FileMd5Util.calculateMD5(file));
        }
        sysFileInfo.setRemark(remark);
        sysFileInfo.setContentType(FileUtil.getMimeType((String)file.getPath()));
        boolean save = this.fileInfoService.save(sysFileInfo);
        return sysFileInfo;
    }

    @Override
    public boolean delete(String fileId) {
        SysFileInfo sysFileInfo = (SysFileInfo)this.fileInfoService.getById((Serializable)((Object)fileId));
        if (Objects.isNull(sysFileInfo)) {
            return true;
        }
        String filePath = sysFileInfo.getFilePath();
        List<SysFileInfo> fileInfoList = this.fileInfoService.findAllByPath(filePath);
        boolean delFlag = true;
        if (fileInfoList.size() <= 1) {
            delFlag = FileUtil.del((String)filePath);
        }
        return this.fileInfoService.removeById((Serializable)((Object)fileId)) && delFlag;
    }

    @Override
    public boolean deleteByBizId(String bizId) {
        List<SysFileInfo> sysFileInfos = this.fileInfoService.findByBizId(bizId);
        sysFileInfos.forEach(et -> this.delete(et.getId()));
        return true;
    }
}

