/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.file.service;

import cn.hutool.core.util.StrUtil;
import com.efficient.common.result.Result;
import com.efficient.file.api.FileService;
import com.efficient.file.api.SysFileInfoService;
import com.efficient.file.constant.FileConstant;
import com.efficient.file.constant.StoreEnum;
import com.efficient.file.model.dto.DownloadVO;
import com.efficient.file.model.entity.SysFileInfo;
import com.efficient.file.model.vo.FileVO;
import com.efficient.file.properties.FileProperties;
import com.efficient.file.properties.MinioProperties;
import com.efficient.file.util.FileMd5Util;
import com.efficient.file.util.MinioUtil;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.multipart.MultipartFile;

public class MinioFileServiceImpl
implements FileService {
    private static final Logger log = LoggerFactory.getLogger(MinioFileServiceImpl.class);
    @Autowired
    private MinioProperties minioProperties;
    @Autowired
    private MinioUtil minioUtil;
    @Autowired
    private SysFileInfoService fileInfoService;

    @Override
    public Result<FileVO> upload(MultipartFile file, boolean unique, String module, String md5, String remark) throws Exception {
        String fileName = this.minioUtil.upload(file, this.minioProperties.getBucketName());
        SysFileInfo sysFileInfo = this.saveFileInfo(file, fileName, remark, md5);
        FileVO fileVO = new FileVO();
        fileVO.setFileName(sysFileInfo.getFileName());
        fileVO.setFilePath(sysFileInfo.getFilePath());
        fileVO.setStoreType(StoreEnum.MINIO.name());
        fileVO.setFileId(sysFileInfo.getId());
        fileVO.setContentType(sysFileInfo.getContentType());
        return Result.ok((Object)fileVO);
    }

    @Override
    public FileVO getFile(DownloadVO downloadVO) {
        SysFileInfo sysFileInfo = (SysFileInfo)this.fileInfoService.getById((Serializable)((Object)downloadVO.getFileId()));
        if (Objects.isNull(sysFileInfo)) {
            return null;
        }
        FileVO vo = new FileVO();
        vo.setFileName(sysFileInfo.getFileName());
        vo.setFileContent(sysFileInfo.getFileContent());
        return vo;
    }

    @Override
    public InputStream getFile(SysFileInfo sysFileInfo) throws Exception {
        if (Objects.isNull(sysFileInfo)) {
            return null;
        }
        return this.minioUtil.getObject(this.minioProperties.getBucketName(), sysFileInfo.getFilePath());
    }

    @Override
    public FileProperties getProperties() {
        return null;
    }

    @Override
    public SysFileInfo saveFileInfo(File file, String md5, String remark) {
        return null;
    }

    @Override
    public boolean delete(String fileId) throws Exception {
        SysFileInfo sysFileInfo = (SysFileInfo)this.fileInfoService.getById((Serializable)((Object)fileId));
        if (Objects.isNull(sysFileInfo)) {
            return true;
        }
        this.minioUtil.removeObject(this.minioProperties.getBucketName(), sysFileInfo.getFilePath());
        return this.fileInfoService.removeById((Serializable)((Object)fileId));
    }

    @Override
    public boolean deleteByBizId(String bizId) {
        List<SysFileInfo> sysFileInfos = this.fileInfoService.findByBizId(bizId);
        sysFileInfos.forEach(et -> {
            try {
                this.delete(et.getId());
            }
            catch (Exception e) {
                log.error("\u5220\u9664minio\u6587\u4ef6\u5931\u8d25\uff1a", (Throwable)e);
            }
        });
        return true;
    }

    public SysFileInfo saveFileInfo(MultipartFile file, String fileName, String remark, String md5) {
        SysFileInfo sysFileInfo = new SysFileInfo();
        sysFileInfo.setStoreType(StoreEnum.MINIO.name());
        sysFileInfo.setFileName(file.getOriginalFilename());
        sysFileInfo.setFilePath(fileName);
        sysFileInfo.setRemark(this.minioProperties.getEndpoint() + "/" + this.minioProperties.getBucketName() + "/" + fileName);
        sysFileInfo.setFileSize(file.getSize() / (long)FileConstant.KB.intValue());
        sysFileInfo.setCreateTime(new Date());
        sysFileInfo.setRemark(remark);
        sysFileInfo.setContentType(file.getContentType());
        if (StrUtil.isBlank((CharSequence)md5)) {
            sysFileInfo.setMd5(FileMd5Util.calculateMD5(file));
        }
        this.fileInfoService.save(sysFileInfo);
        return sysFileInfo;
    }
}

