/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.file.aop;

import com.efficient.common.result.Result;
import com.efficient.file.api.SysFileInfoService;
import com.efficient.file.model.dto.FileIdList;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class AutoSaveFileInfoAspect {
    private static final Logger log = LoggerFactory.getLogger(AutoSaveFileInfoAspect.class);
    @Autowired
    private SysFileInfoService fileInfoService;
    @Autowired
    private HttpServletRequest request;

    @Pointcut(value="@annotation(com.efficient.file.annotation.AutoSaveFileInfo)")
    public void pointCut() {
    }

    @AfterReturning(value="pointCut()", returning="resultObject")
    public void doAfterLog(JoinPoint joinPoint, Object resultObject) {
        try {
            FileIdList firstArg;
            Object[] args;
            Result result;
            Integer code;
            if (resultObject instanceof Result && !Objects.equals(code = (result = (Result)resultObject).getCode(), Result.ok().getCode())) {
                return;
            }
            if ("POST".equalsIgnoreCase(this.request.getMethod()) && (args = joinPoint.getArgs()).length > 0 && Objects.nonNull(firstArg = (FileIdList)args[0])) {
                boolean saved;
                String bizId = firstArg.getBizId();
                List<String> fileIdList = firstArg.getFileIdList();
                if (bizId != null && fileIdList != null && !(saved = this.fileInfoService.saveIdListByBizId(fileIdList, bizId))) {
                    log.info("\u6587\u4ef6\u5173\u8054\u5931\u8d25");
                }
            }
        }
        catch (Exception e) {
            log.info("\u6587\u4ef6\u5173\u8054\u5f02\u5e38", (Throwable)e);
        }
    }

    private <T> T getField(Object object, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        for (Class<?> current = object.getClass(); current != Object.class; current = current.getSuperclass()) {
            try {
                Field field = current.getDeclaredField(fieldName);
                field.setAccessible(true);
                return (T)field.get(object);
            }
            catch (NoSuchFieldException e) {
                continue;
            }
        }
        throw new NoSuchFieldException("The field '" + fieldName + "' was not found in " + object.getClass() + " or its superclasses.");
    }
}

