/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.file.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.efficient.file.api.SysFileInfoService;
import com.efficient.file.constant.FileConstant;
import com.efficient.file.constant.StoreEnum;
import com.efficient.file.dao.SysFileInfoMapper;
import com.efficient.file.model.entity.SysFileInfo;
import com.efficient.file.model.vo.FileVO;
import com.efficient.file.properties.FileProperties;
import com.efficient.file.util.FileMd5Util;
import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysFileInfoServiceImpl
extends ServiceImpl<SysFileInfoMapper, SysFileInfo>
implements SysFileInfoService {
    @Autowired
    private SysFileInfoMapper fileInfoMapper;
    @Autowired
    private FileProperties fileProperties;

    @Override
    public SysFileInfo findByPathFirst(String destFile) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysFileInfo::getFilePath, (Object)destFile);
        queryWrapper.orderByAsc(SysFileInfo::getId);
        queryWrapper.last(" limit 1");
        return (SysFileInfo)this.fileInfoMapper.selectOne((Wrapper)queryWrapper);
    }

    @Override
    public SysFileInfo findByPathAndMd5(String destFile, String md5) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysFileInfo::getFilePath, (Object)destFile);
        queryWrapper.eq(SysFileInfo::getMd5, (Object)md5);
        queryWrapper.orderByAsc(SysFileInfo::getId);
        queryWrapper.last(" limit 1");
        return (SysFileInfo)this.fileInfoMapper.selectOne((Wrapper)queryWrapper);
    }

    @Override
    public boolean saveIdListByBizId(List<String> fileIdList, String bizId) {
        if (CollUtil.isEmpty(fileIdList) || StrUtil.isBlank((CharSequence)bizId)) {
            return false;
        }
        this.fileInfoMapper.deleteByFIleIdListAndBizId(fileIdList, bizId);
        this.fileInfoMapper.setBizIdWithFileIdList(fileIdList, bizId);
        return true;
    }

    @Override
    public boolean saveFileListByBizId(List<FileVO> fileList, String bizId) {
        if (CollUtil.isEmpty(fileList) || StrUtil.isBlank((CharSequence)bizId)) {
            return false;
        }
        List<String> fileIdList = fileList.stream().map(FileVO::getFileId).collect(Collectors.toList());
        return this.saveIdListByBizId(fileIdList, bizId);
    }

    @Override
    public boolean saveStrListByBizId(String fileIdStr, String bizId) {
        if (StrUtil.isBlank((CharSequence)fileIdStr) || StrUtil.isBlank((CharSequence)bizId)) {
            return false;
        }
        String[] split = fileIdStr.split(",");
        return this.saveIdListByBizId(Arrays.asList(split), bizId);
    }

    @Override
    public List<SysFileInfo> findByBizId(String bizId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper(SysFileInfo.class);
        queryWrapper.select(new SFunction[]{SysFileInfo::getId, SysFileInfo::getBizId, SysFileInfo::getFileName, SysFileInfo::getFileSize, SysFileInfo::getRemark});
        queryWrapper.eq(SysFileInfo::getBizId, (Object)bizId);
        queryWrapper.orderByAsc(SysFileInfo::getCreateTime);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<SysFileInfo> findByBizIdList(List<String> bizIdList) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper(SysFileInfo.class);
        queryWrapper.select(new SFunction[]{SysFileInfo::getId, SysFileInfo::getBizId, SysFileInfo::getFileName, SysFileInfo::getFileSize, SysFileInfo::getRemark});
        queryWrapper.in(SysFileInfo::getBizId, bizIdList);
        queryWrapper.orderByAsc(SysFileInfo::getCreateTime);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public void deleteByBizId(String bizId) {
        this.fileInfoMapper.deleteByBizId(bizId);
    }

    @Override
    public List<SysFileInfo> findAllByPath(String filePath) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysFileInfo::getFilePath, (Object)filePath);
        return this.fileInfoMapper.selectList((Wrapper)queryWrapper);
    }

    @Override
    public SysFileInfo findByBizIdAndRemark(String bizId, String remark) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper(SysFileInfo.class);
        queryWrapper.eq(SysFileInfo::getBizId, (Object)bizId);
        queryWrapper.eq(SysFileInfo::getRemark, (Object)remark);
        queryWrapper.last(" limit 1");
        return (SysFileInfo)this.fileInfoMapper.selectOne((Wrapper)queryWrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File getDownPath(String fileName) {
        String reName = System.currentTimeMillis() + "_" + fileName;
        String filePath = this.fileProperties.getLocal().getLocalPath() + "/download/" + DateUtil.format((Date)new Date(), (String)"/yyyy/MM/dd/") + reName;
        File file = new File(filePath);
        SysFileInfoServiceImpl sysFileInfoServiceImpl = this;
        synchronized (sysFileInfoServiceImpl) {
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
        }
        return file;
    }

    @Override
    public SysFileInfo saveDownFile(File downLoadFile, String bizId, String fileName, String remark) {
        SysFileInfo sysFileInfo = new SysFileInfo();
        sysFileInfo.setBizId(bizId);
        sysFileInfo.setStoreType(StoreEnum.LOCAL.name());
        sysFileInfo.setFileName(fileName);
        sysFileInfo.setFilePath(downLoadFile.getAbsolutePath());
        sysFileInfo.setFileSize(FileUtil.size((File)downLoadFile) / (long)FileConstant.KB.intValue());
        sysFileInfo.setCreateTime(new Date());
        sysFileInfo.setMd5(FileMd5Util.calculateMD5(downLoadFile));
        sysFileInfo.setRemark(remark);
        sysFileInfo.setContentType(FileUtil.getMimeType((String)downLoadFile.getPath()));
        this.save(sysFileInfo);
        return sysFileInfo;
    }

    @Override
    public SysFileInfo findById(String id) {
        return (SysFileInfo)this.getById((Serializable)((Object)id));
    }

    @Override
    public SysFileInfo findByPath(String filePath) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysFileInfo::getFilePath, (Object)filePath);
        queryWrapper.orderByDesc(SysFileInfo::getCreateTime);
        queryWrapper.last(" limit 1");
        return (SysFileInfo)this.getOne((Wrapper)queryWrapper);
    }
}

