/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.file.service;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.StrUtil;
import com.efficient.common.constant.CommonConstant;
import com.efficient.common.result.Result;
import com.efficient.common.util.RedissonUtil;
import com.efficient.file.api.SysFileInfoService;
import com.efficient.file.api.VideoService;
import com.efficient.file.constant.FileConstant;
import com.efficient.file.constant.StoreEnum;
import com.efficient.file.model.dto.FileChunkDTO;
import com.efficient.file.model.entity.SysFileInfo;
import com.efficient.file.properties.FileProperties;
import java.io.File;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Date;
import java.util.Objects;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import org.springframework.util.DigestUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class VideoServiceImpl
implements VideoService {
    private static final Logger log = LoggerFactory.getLogger(VideoServiceImpl.class);
    private final String FILE_PATH = "%s" + File.separator + "%s" + File.separator + "%s";
    @Autowired
    private FileProperties fileProperties;
    @Autowired
    private SysFileInfoService sysFileInfoService;
    @Value(value="${com.efficient.cache.active:ehcache}")
    private String cacheType;
    @Value(value="${com.efficient.cache.redis.enableRedisson:false}")
    private boolean enableRedisson;
    @Autowired
    private ApplicationContext applicationContext;

    @Override
    public Result<SysFileInfo> chunkUpload(FileChunkDTO fileChunkDTO) throws Exception {
        SysFileInfo sysFileInfo;
        String md5 = fileChunkDTO.getMd5();
        Integer totalChunk = fileChunkDTO.getTotalChunk();
        MultipartFile file = fileChunkDTO.getFile();
        String contentType = file.getContentType();
        String filename = file.getOriginalFilename();
        Integer currChunk = fileChunkDTO.getCurrChunk();
        Long chunkSize = fileChunkDTO.getChunkSize();
        String basePath = this.fileProperties.getLocal().getLocalPath() + "/upload/" + "/chunk/" + fileChunkDTO.getModule();
        if (this.fileProperties.getLocal().isAddDatePrefix()) {
            basePath = basePath + DateUtil.format((Date)new Date(), (String)"/yyyy/MM/dd/");
        }
        String destFilePath = String.format(this.FILE_PATH + ".%s", basePath, md5, md5, StringUtils.getFilenameExtension((String)filename));
        File destFile = new File(destFilePath);
        String confFile = String.format(this.FILE_PATH + ".conf", basePath, md5, md5);
        File dir = new File(destFilePath).getParentFile();
        if (!dir.exists()) {
            dir.mkdirs();
            byte[] bytes = new byte[totalChunk.intValue()];
            Files.write(Paths.get(confFile, new String[0]), bytes, new OpenOption[0]);
        }
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(destFile, "rw");
             RandomAccessFile randomAccessConfFile = new RandomAccessFile(confFile, "rw");
             InputStream inputStream = file.getInputStream();){
            randomAccessFile.seek((long)currChunk.intValue() * chunkSize);
            randomAccessFile.write(IoUtil.readBytes((InputStream)inputStream));
            randomAccessConfFile.seek(currChunk.intValue());
            randomAccessConfFile.write(1);
        }
        if (StrUtil.equals((CharSequence)this.cacheType, (CharSequence)"redis") && this.enableRedisson) {
            RedissonClient redissonClient = (RedissonClient)this.applicationContext.getBean(RedissonClient.class);
            String lockName = "chunkUpload:" + md5;
            sysFileInfo = (SysFileInfo)RedissonUtil.execute((RedissonClient)redissonClient, (String)lockName, null, param -> {
                SysFileInfo sysFileInfoNew = this.sysFileInfoService.findByPathAndMd5(destFile.getAbsolutePath(), md5);
                if (Objects.isNull(sysFileInfoNew)) {
                    sysFileInfoNew = new SysFileInfo();
                    sysFileInfoNew.setStoreType(StoreEnum.LOCAL.name());
                    sysFileInfoNew.setFileName(file.getOriginalFilename());
                    sysFileInfoNew.setFilePath(destFile.getAbsolutePath());
                    sysFileInfoNew.setFileSize((long)totalChunk.intValue() * chunkSize / (long)FileConstant.KB.intValue());
                    sysFileInfoNew.setCreateTime(new Date());
                    sysFileInfoNew.setMd5(md5);
                    sysFileInfoNew.setIsIntact(CommonConstant.FALSE_INT);
                    sysFileInfoNew.setContentType(contentType);
                    this.sysFileInfoService.save(sysFileInfoNew);
                }
                return sysFileInfoNew;
            }, param -> this.sysFileInfoService.findByPathAndMd5(destFile.getAbsolutePath(), md5));
        } else {
            fileChunkDTO.setContentType(contentType);
            sysFileInfo = this.getFileInfo(fileChunkDTO, destFile.getAbsolutePath());
        }
        Result<String> stringResult = this.checkFile(fileChunkDTO.getModule(), fileChunkDTO.getMd5());
        String data = (String)stringResult.getData();
        if (Objects.nonNull(sysFileInfo) && StrUtil.isNotBlank((CharSequence)data) && !data.contains("0")) {
            sysFileInfo.setIsIntact(CommonConstant.TRUE_INT);
            this.sysFileInfoService.updateById(sysFileInfo);
        }
        return Result.ok((Object)sysFileInfo);
    }

    public synchronized SysFileInfo getFileInfo(FileChunkDTO fileChunkDTO, String destFile) {
        String md5 = fileChunkDTO.getMd5();
        Integer totalChunk = fileChunkDTO.getTotalChunk();
        Long chunkSize = fileChunkDTO.getChunkSize();
        SysFileInfo sysFileInfo = this.sysFileInfoService.findByPathAndMd5(destFile, md5);
        if (Objects.isNull(sysFileInfo)) {
            sysFileInfo = new SysFileInfo();
            sysFileInfo.setStoreType(StoreEnum.LOCAL.name());
            sysFileInfo.setFileName(fileChunkDTO.getFilename());
            sysFileInfo.setFilePath(destFile);
            sysFileInfo.setFileSize((long)totalChunk.intValue() * chunkSize / (long)FileConstant.KB.intValue());
            sysFileInfo.setCreateTime(new Date());
            sysFileInfo.setMd5(md5);
            sysFileInfo.setContentType(fileChunkDTO.getContentType());
            sysFileInfo.setIsIntact(CommonConstant.FALSE_INT);
            this.sysFileInfoService.save(sysFileInfo);
        }
        return sysFileInfo;
    }

    public Result<String> checkFile(String module, String md5) throws Exception {
        byte[] bytes;
        String uploadPath;
        Path path;
        String basePath = this.fileProperties.getLocal().getLocalPath() + "/upload/" + "/chunk/" + module;
        if (this.fileProperties.getLocal().isAddDatePrefix()) {
            basePath = basePath + DateUtil.format((Date)new Date(), (String)"/yyyy/MM/dd/");
        }
        if (!Files.exists((path = Paths.get(uploadPath = String.format(this.FILE_PATH + ".conf", basePath, md5, md5), new String[0])).getParent(), new LinkOption[0])) {
            return Result.ok();
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (byte b : bytes = Files.readAllBytes(path)) {
            stringBuilder.append(String.valueOf(b));
        }
        if (!stringBuilder.toString().contains("0")) {
            File file = new File(String.format("%s" + File.separator + "%s", basePath, md5));
            if (!file.exists()) {
                return Result.ok((Object)stringBuilder.toString().replaceAll("1", "0"));
            }
            File[] files = file.listFiles();
            if (Objects.isNull(files) || files.length < 2) {
                return Result.ok((Object)stringBuilder.toString().replaceAll("1", "0"));
            }
            for (File f : files) {
                if (f.getName().contains("conf")) continue;
                try (InputStream inputStream = Files.newInputStream(f.toPath(), new OpenOption[0]);){
                    String md5pwd = DigestUtils.md5DigestAsHex((InputStream)inputStream);
                    if (md5pwd.equalsIgnoreCase(md5)) continue;
                    Result result = Result.ok((Object)stringBuilder.toString().replaceAll("1", "0"));
                    return result;
                }
            }
        }
        return Result.ok((Object)stringBuilder.toString());
    }

    public Result<SysFileInfo> quickUpload(String module, String md5, String fileName, String remark) {
        String basePath = this.fileProperties.getLocal().getLocalPath() + "/upload/" + "/chunk/" + module;
        if (this.fileProperties.getLocal().isAddDatePrefix()) {
            basePath = basePath + DateUtil.format((Date)new Date(), (String)"/yyyy/MM/dd/");
        }
        String suffix = FileUtil.getSuffix((String)fileName);
        String uploadPath = String.format("%s\\%s\\%s.%s", basePath, md5, md5, suffix);
        File destFile = new File(uploadPath);
        String path = destFile.getAbsolutePath();
        SysFileInfo byPathAndMd5 = this.sysFileInfoService.findByPathAndMd5(path, md5);
        if (Objects.isNull(byPathAndMd5)) {
            byPathAndMd5 = new SysFileInfo();
            byPathAndMd5.setStoreType(StoreEnum.LOCAL.name());
            byPathAndMd5.setFileName(fileName);
            byPathAndMd5.setFilePath(destFile.getAbsolutePath());
            byPathAndMd5.setFileSize(destFile.length() / (long)FileConstant.KB.intValue());
            byPathAndMd5.setCreateTime(new Date());
            byPathAndMd5.setIsIntact(1);
            byPathAndMd5.setRemark(remark);
            byPathAndMd5.setMd5(md5);
            byPathAndMd5.setContentType(FileUtil.getMimeType((String)destFile.getPath()));
        } else {
            byPathAndMd5.setId(null);
            byPathAndMd5.setBizId(null);
            byPathAndMd5.setRemark(remark);
            byPathAndMd5.setCreateTime(new Date());
            byPathAndMd5.setFileName(fileName);
        }
        this.sysFileInfoService.save(byPathAndMd5);
        return Result.ok((Object)byPathAndMd5);
    }
}

