/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.file.util;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import com.efficient.file.properties.MinioProperties;
import io.minio.BucketExistsArgs;
import io.minio.GetObjectArgs;
import io.minio.GetObjectResponse;
import io.minio.GetPresignedObjectUrlArgs;
import io.minio.ListObjectsArgs;
import io.minio.MakeBucketArgs;
import io.minio.MinioClient;
import io.minio.PutObjectArgs;
import io.minio.RemoveBucketArgs;
import io.minio.RemoveObjectArgs;
import io.minio.Result;
import io.minio.StatObjectArgs;
import io.minio.StatObjectResponse;
import io.minio.http.Method;
import io.minio.messages.Bucket;
import io.minio.messages.Item;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.compress.utils.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.FastByteArrayOutputStream;
import org.springframework.util.MultiValueMap;
import org.springframework.web.multipart.MultipartFile;

@Component
@ConditionalOnProperty(name={"com.efficient.file.active"}, havingValue="minio")
public class MinioUtil {
    private static final Logger log = LoggerFactory.getLogger(MinioUtil.class);
    @Autowired
    private MinioProperties minioProperties;
    @Autowired
    private MinioClient minioClient;

    public void createBucket(String bucketName) throws Exception {
        if (!this.minioClient.bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(bucketName)).build())) {
            this.minioClient.makeBucket((MakeBucketArgs)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(bucketName)).build());
        }
    }

    public String upload(MultipartFile file) throws Exception {
        return this.upload(file, this.minioProperties.getBucketName());
    }

    public String upload(MultipartFile file, String bucketName) throws Exception {
        if (null == file || 0L == file.getSize()) {
            return null;
        }
        this.createBucket(bucketName);
        String originalFilename = file.getOriginalFilename();
        assert (originalFilename != null);
        String fileName = DateUtil.format((Date)DateUtil.date(), (String)"yyyy-MM/dd/") + originalFilename;
        this.minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(bucketName)).object(fileName)).stream(file.getInputStream(), file.getSize(), -1L).contentType(file.getContentType()).build());
        return fileName;
    }

    public String upload(File file, String bucketName) throws Exception {
        if (null == file || 0L == file.length()) {
            return null;
        }
        this.createBucket(bucketName);
        String originalFilename = file.getName();
        Path path = file.toPath();
        assert (originalFilename != null);
        String fileName = DateUtil.format((Date)DateUtil.date(), (String)"yyyy-MM/dd/") + originalFilename;
        this.minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(bucketName)).object(fileName)).stream(Files.newInputStream(path, new OpenOption[0]), file.length(), -1L).contentType(FileUtil.getMimeType((Path)path)).build());
        return fileName;
    }

    public String upload(File file) throws Exception {
        return this.upload(file, this.minioProperties.getBucketName());
    }

    public List<Bucket> getAllBuckets() throws Exception {
        return this.minioClient.listBuckets();
    }

    public Bucket getBucket(String bucketName) throws Exception {
        return this.minioClient.listBuckets().stream().filter(b -> b.name().equals(bucketName)).findFirst().orElse(null);
    }

    public void removeBucket(String bucketName) throws Exception {
        this.minioClient.removeBucket((RemoveBucketArgs)((RemoveBucketArgs.Builder)RemoveBucketArgs.builder().bucket(bucketName)).build());
    }

    public String getObjectUrl(String bucketName, String objectName, Integer expires) throws Exception {
        return this.minioClient.getPresignedObjectUrl((GetPresignedObjectUrlArgs)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)GetPresignedObjectUrlArgs.builder().method(Method.GET).bucket(bucketName)).object(objectName)).expiry(expires.intValue()).build());
    }

    public String getObjectUrl(String bucketName, String objectName) throws Exception {
        return this.minioClient.getPresignedObjectUrl((GetPresignedObjectUrlArgs)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)GetPresignedObjectUrlArgs.builder().method(Method.GET).bucket(bucketName)).object(objectName)).build());
    }

    public InputStream getObject(String bucketName, String objectName) throws Exception {
        return this.minioClient.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(bucketName)).object(objectName)).build());
    }

    public void getObject(String bucketName, String objectName, HttpServletResponse rep) throws Exception {
        GetObjectArgs objectArgs = (GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(bucketName)).object(objectName)).build();
        try (GetObjectResponse response = this.minioClient.getObject(objectArgs);){
            byte[] buf = new byte[1024];
            try (FastByteArrayOutputStream os = new FastByteArrayOutputStream();){
                int len;
                while ((len = response.read(buf)) != -1) {
                    os.write(buf, 0, len);
                }
                os.flush();
                byte[] bytes = os.toByteArray();
                rep.setCharacterEncoding("utf-8");
                rep.setContentType("*/*");
                rep.addHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(objectName, StandardCharsets.UTF_8.name()));
                try (ServletOutputStream stream = rep.getOutputStream();){
                    stream.write(bytes);
                    stream.flush();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseEntity<byte[]> download(String bucketName, String objectName) {
        ResponseEntity responseEntity = null;
        ByteArrayOutputStream out = null;
        try (GetObjectResponse in = this.minioClient.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(bucketName)).object(objectName)).build());){
            out = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)in, (OutputStream)out);
            byte[] bytes = out.toByteArray();
            HttpHeaders headers = new HttpHeaders();
            headers.add("Content-Disposition", "attachment;filename=" + URLEncoder.encode(objectName, StandardCharsets.UTF_8.name()));
            headers.setContentLength((long)bytes.length);
            headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
            headers.setAccessControlExposeHeaders(Collections.singletonList("*"));
            responseEntity = new ResponseEntity((Object)bytes, (MultiValueMap)headers, HttpStatus.OK);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return responseEntity;
    }

    public void putObject(String bucketName, String objectName, InputStream stream) throws Exception {
        this.minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(bucketName)).object(objectName)).stream(stream, (long)stream.available(), -1L).contentType(objectName.substring(objectName.lastIndexOf("."))).build());
    }

    public void putObject(String bucketName, String objectName, InputStream stream, long size, String contextType) throws Exception {
        this.minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(bucketName)).object(objectName)).stream(stream, size, -1L).contentType(contextType).build());
    }

    public StatObjectResponse getObjectInfo(String bucketName, String objectName) throws Exception {
        return this.minioClient.statObject((StatObjectArgs)((StatObjectArgs.Builder)((StatObjectArgs.Builder)StatObjectArgs.builder().bucket(bucketName)).object(objectName)).build());
    }

    public void removeObject(String bucketName, String objectName) throws Exception {
        this.minioClient.removeObject((RemoveObjectArgs)((RemoveObjectArgs.Builder)((RemoveObjectArgs.Builder)RemoveObjectArgs.builder().bucket(bucketName)).object(objectName)).build());
    }

    public List<Item> listObjects(String bucketName) {
        Iterable results = this.minioClient.listObjects((ListObjectsArgs)((ListObjectsArgs.Builder)ListObjectsArgs.builder().bucket(bucketName)).build());
        ArrayList<Item> items = new ArrayList<Item>();
        try {
            for (Result result : results) {
                items.add((Item)result.get());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return items;
    }
}

