/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.form.service;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.efficient.common.constant.CommonConstant;
import com.efficient.common.constant.DbConstant;
import com.efficient.form.api.DynamicFormsFieldsService;
import com.efficient.form.dao.DynamicFormsFieldsMapper;
import com.efficient.form.model.converter.DynamicFormsFieldsConverter;
import com.efficient.form.model.entity.DynamicFormsFields;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DynamicFormsFieldsServiceImpl
extends ServiceImpl<DynamicFormsFieldsMapper, DynamicFormsFields>
implements DynamicFormsFieldsService {
    @Autowired
    private DynamicFormsFieldsConverter dynamicFormsFieldsConverter;
    @Autowired
    private DynamicFormsFieldsMapper dynamicFormsFieldsMapper;

    @Override
    public List<DynamicFormsFields> findByFormsId(String formsId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(DynamicFormsFields::getFormsId, (Object)formsId);
        queryWrapper.orderByAsc(DynamicFormsFields::getSort);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public void saveByFormsId(String formsId, List<DynamicFormsFields> formsFieldsList) {
        this.dynamicFormsFieldsMapper.deleteByFormsId(formsId);
        formsFieldsList.forEach(et -> et.setFormsId(formsId));
        this.saveBatch(formsFieldsList, DbConstant.BATCH_SIZE);
    }

    @Override
    public void deleteByFormsId(String formsId) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(DynamicFormsFields::getFormsId, (Object)formsId);
        updateWrapper.set(DynamicFormsFields::getIsDelete, (Object)CommonConstant.TRUE_INT);
        this.update((Wrapper)updateWrapper);
    }
}

