/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.form.service;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.efficient.common.result.Result;
import com.efficient.common.util.JackSonUtil;
import com.efficient.configs.config.DatabaseConfig;
import com.efficient.form.api.DynamicFormsDataDetailService;
import com.efficient.form.api.DynamicFormsDataService;
import com.efficient.form.dao.DynamicFormsDataMapper;
import com.efficient.form.model.converter.DynamicFormsDataConverter;
import com.efficient.form.model.dto.DynamicFormsDataDTO;
import com.efficient.form.model.dto.DynamicFormsDataListDTO;
import com.efficient.form.model.entity.DynamicFormsData;
import com.efficient.form.model.entity.DynamicFormsDataDetail;
import com.efficient.form.model.vo.DynamicFormsDataVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DynamicFormsDataServiceImpl
extends ServiceImpl<DynamicFormsDataMapper, DynamicFormsData>
implements DynamicFormsDataService {
    @Autowired
    private DynamicFormsDataConverter dynamicFormsDataConverter;
    @Autowired
    private DynamicFormsDataMapper dynamicFormsDataMapper;
    @Autowired
    private DynamicFormsDataDetailService dynamicFormsDataDetailService;
    @Autowired
    private DatabaseConfig databaseConfig;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Result<DynamicFormsData> save(DynamicFormsDataDTO dto) {
        DynamicFormsData entity = this.dynamicFormsDataConverter.dto2Entity(dto);
        entity.setRecordData(JackSonUtil.toJson(dto.getDataDetailList()));
        boolean flag = this.save(entity);
        List<DynamicFormsDataDetail> dataDetailList = dto.getDataDetailList();
        this.dynamicFormsDataDetailService.saveByDataId(entity.getFormsId(), entity.getId(), dataDetailList);
        return Result.ok((Object)entity);
    }

    @Override
    public Result<DynamicFormsDataVO> findById(String id) {
        DynamicFormsData entity = (DynamicFormsData)this.getById((Serializable)((Object)id));
        DynamicFormsDataVO vo = this.dynamicFormsDataConverter.entity2Vo(entity);
        List<DynamicFormsDataDetail> dataDetailList = this.dynamicFormsDataDetailService.findByDataId(id);
        vo.setDataDetailList(dataDetailList);
        return Result.ok((Object)vo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Result<Boolean> update(DynamicFormsDataDTO dto) {
        DynamicFormsData dynamicFormsData = this.dynamicFormsDataConverter.dto2Entity(dto);
        dynamicFormsData.setRecordData(JackSonUtil.toJson(dto.getDataDetailList()));
        boolean flag = this.updateById(dynamicFormsData);
        this.dynamicFormsDataDetailService.saveByDataId(dto.getFormsId(), dto.getId(), dto.getDataDetailList());
        return flag ? Result.ok() : Result.fail();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Result<Boolean> delete(String id) {
        boolean flag = this.removeById((Serializable)((Object)id));
        this.dynamicFormsDataDetailService.deleteByDataId(id);
        return flag ? Result.ok() : Result.fail();
    }

    @Override
    public Page<Map<String, Object>> list(DynamicFormsDataListDTO dto) {
        Page page = new Page((long)dto.getPageNum().intValue(), (long)dto.getPageSize().intValue());
        dto.setDbType(this.databaseConfig.getDbType().getDb());
        Page<Map<String, Object>> pageResult = this.dynamicFormsDataMapper.listMap((Page<Map<String, Object>>)page, dto);
        List records = pageResult.getRecords();
        if (CollUtil.isEmpty((Collection)records)) {
            return pageResult;
        }
        ArrayList resultList = new ArrayList();
        records.forEach(et -> {
            HashMap map = new HashMap();
            map.put("dataId", et.get("data_id"));
            String dataStr = (String)et.get("data");
            Map dataMap = JackSonUtil.toMap((String)dataStr);
            if (Objects.nonNull(dataMap)) {
                map.putAll(dataMap);
            }
            resultList.add(map);
        });
        pageResult.setRecords(resultList);
        return pageResult;
    }
}

