/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.form.service;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.efficient.common.constant.CommonConstant;
import com.efficient.common.constant.DbConstant;
import com.efficient.form.api.DynamicFormsDataDetailService;
import com.efficient.form.dao.DynamicFormsDataDetailMapper;
import com.efficient.form.model.converter.DynamicFormsDataDetailConverter;
import com.efficient.form.model.entity.DynamicFormsDataDetail;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DynamicFormsDataDetailServiceImpl
extends ServiceImpl<DynamicFormsDataDetailMapper, DynamicFormsDataDetail>
implements DynamicFormsDataDetailService {
    @Autowired
    private DynamicFormsDataDetailConverter dynamicFormsDataDetailConverter;
    @Autowired
    private DynamicFormsDataDetailMapper dynamicFormsDataDetailMapper;

    @Override
    public void saveByDataId(String formsId, String dataId, List<DynamicFormsDataDetail> dataDetailList) {
        this.dynamicFormsDataDetailMapper.deleteByDataId(dataId);
        dataDetailList.forEach(et -> {
            et.setDataId(dataId);
            et.setFormsId(formsId);
        });
        this.saveBatch(dataDetailList, DbConstant.BATCH_SIZE);
    }

    @Override
    public void deleteByDataId(String dataId) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(DynamicFormsDataDetail::getDataId, (Object)dataId);
        updateWrapper.set(DynamicFormsDataDetail::getIsDelete, (Object)CommonConstant.TRUE_INT);
        this.update((Wrapper)updateWrapper);
    }

    @Override
    public List<DynamicFormsDataDetail> findByDataId(String dataId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(DynamicFormsDataDetail::getDataId, (Object)dataId);
        queryWrapper.orderByAsc(DynamicFormsDataDetail::getId);
        return this.list((Wrapper)queryWrapper);
    }
}

