/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.form.service;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.efficient.common.result.Result;
import com.efficient.form.api.DynamicFormsFieldsService;
import com.efficient.form.api.DynamicFormsService;
import com.efficient.form.dao.DynamicFormsMapper;
import com.efficient.form.model.converter.DynamicFormsConverter;
import com.efficient.form.model.converter.DynamicFormsFieldsConverter;
import com.efficient.form.model.dto.DynamicFormsDTO;
import com.efficient.form.model.dto.DynamicFormsListDTO;
import com.efficient.form.model.entity.DynamicForms;
import com.efficient.form.model.entity.DynamicFormsFields;
import com.efficient.form.model.vo.DynamicFormsVO;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DynamicFormsServiceImpl
extends ServiceImpl<DynamicFormsMapper, DynamicForms>
implements DynamicFormsService {
    @Autowired
    private DynamicFormsConverter dynamicFormsConverter;
    @Autowired
    private DynamicFormsMapper dynamicFormsMapper;
    @Autowired
    private DynamicFormsFieldsService dynamicFormsFieldsService;
    @Autowired
    private DynamicFormsFieldsConverter dynamicFormsFieldsConverter;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Result<DynamicForms> save(DynamicFormsDTO dto) {
        DynamicForms entity = this.dynamicFormsConverter.dto2Entity(dto);
        boolean flag = this.save(entity);
        this.dynamicFormsFieldsService.saveByFormsId(entity.getId(), dto.getFormsFieldsList());
        return Result.ok((Object)entity);
    }

    @Override
    public Result<DynamicFormsVO> findById(String id) {
        DynamicForms entity = (DynamicForms)this.getById((Serializable)((Object)id));
        DynamicFormsVO vo = this.dynamicFormsConverter.entity2Vo(entity);
        List<DynamicFormsFields> fieldsList = this.dynamicFormsFieldsService.findByFormsId(id);
        vo.setFormsFieldsList(fieldsList);
        return Result.ok((Object)vo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Result<Boolean> update(DynamicFormsDTO dto) {
        boolean flag = this.updateById(this.dynamicFormsConverter.dto2Entity(dto));
        this.dynamicFormsFieldsService.saveByFormsId(dto.getId(), dto.getFormsFieldsList());
        return flag ? Result.ok() : Result.fail();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Result<Boolean> delete(String id) {
        boolean flag = this.removeById((Serializable)((Object)id));
        this.dynamicFormsFieldsService.deleteByFormsId(id);
        return flag ? Result.ok() : Result.fail();
    }

    @Override
    public Page<DynamicForms> list(DynamicFormsListDTO dto) {
        Integer isEnabled;
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper(DynamicForms.class);
        String name = dto.getName();
        if (StrUtil.isNotBlank((CharSequence)name)) {
            queryWrapper.like(DynamicForms::getName, (Object)name);
        }
        if (Objects.nonNull(isEnabled = dto.getIsEnabled())) {
            queryWrapper.like(DynamicForms::getIsEnabled, (Object)isEnabled);
        }
        queryWrapper.orderByDesc(DynamicForms::getCreateTime);
        Page page = (Page)this.dynamicFormsMapper.selectPage((IPage)new Page((long)dto.getPageNum().intValue(), (long)dto.getPageSize().intValue()), (Wrapper)queryWrapper);
        return page;
    }

    @Override
    public Result<Boolean> changeEnabled(String id, Integer isEnabled) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(DynamicForms::getId, (Object)id);
        updateWrapper.set(DynamicForms::getIsEnabled, (Object)isEnabled);
        boolean flag = this.update((Wrapper)updateWrapper);
        return flag ? Result.ok() : Result.fail();
    }
}

