/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.form.controller;

import com.efficient.common.permission.Permission;
import com.efficient.common.result.Result;
import com.efficient.form.api.DynamicFormsService;
import com.efficient.form.model.dto.DynamicFormsDTO;
import com.efficient.form.model.dto.DynamicFormsListDTO;
import com.efficient.form.model.entity.DynamicForms;
import com.efficient.form.model.vo.DynamicFormsVO;
import com.efficient.logs.annotation.Log;
import com.efficient.logs.constant.LogEnum;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/dynamicForms"})
@Validated
@Api(tags={"\u7cfb\u7edf\u52a8\u6001\u8868\u5355"})
@Permission
public class DynamicFormsController {
    @Autowired
    private DynamicFormsService dynamicFormsService;

    @Log(logOpt=LogEnum.SAVE, module="\u7cfb\u7edf\u52a8\u6001\u8868\u5355")
    @PostMapping(value={"/save"})
    @ApiOperation(value="\u4fdd\u5b58")
    public Result<DynamicForms> save(@Validated @RequestBody DynamicFormsDTO dto) {
        return this.dynamicFormsService.save(dto);
    }

    @Log(logOpt=LogEnum.QUERY, module="\u7cfb\u7edf\u52a8\u6001\u8868\u5355")
    @GetMapping(value={"/find"})
    @ApiOperation(value="\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u6570\u636e\u552f\u4e00\u6807\u8bc6", required=true)})
    public Result<DynamicFormsVO> find(@NotBlank(message="id \u4e0d\u80fd\u4e3a\u7a7a") @RequestParam(name="id") @NotBlank(message="id \u4e0d\u80fd\u4e3a\u7a7a") String id) {
        return this.dynamicFormsService.findById(id);
    }

    @Log(logOpt=LogEnum.UPDATE, module="\u7cfb\u7edf\u52a8\u6001\u8868\u5355")
    @PostMapping(value={"/update"})
    @ApiOperation(value="\u4fee\u6539")
    public Result<Boolean> update(@Validated @RequestBody DynamicFormsDTO dto) {
        return this.dynamicFormsService.update(dto);
    }

    @Log(logOpt=LogEnum.DELETE, module="\u7cfb\u7edf\u52a8\u6001\u8868\u5355")
    @GetMapping(value={"/delete"})
    @ApiOperation(value="\u5220\u9664")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u6570\u636e\u552f\u4e00\u6807\u8bc6", required=true)})
    public Result<Boolean> delete(@NotBlank(message="id \u4e0d\u80fd\u4e3a\u7a7a") @RequestParam(name="id") @NotBlank(message="id \u4e0d\u80fd\u4e3a\u7a7a") String id) {
        return this.dynamicFormsService.delete(id);
    }

    @Log(logOpt=LogEnum.DELETE, module="\u7cfb\u7edf\u52a8\u6001\u8868\u5355")
    @GetMapping(value={"/changeEnabled"})
    @ApiOperation(value="\u6539\u53d8\u662f\u5426\u542f\u7528")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u6570\u636e\u552f\u4e00\u6807\u8bc6", required=true), @ApiImplicitParam(name="isEnabled", value="\u662f\u5426\u542f\u7528\uff0c1-\u662f\uff0c0-\u5426", required=true)})
    public Result<Boolean> changeEnabled(@NotBlank(message="id \u4e0d\u80fd\u4e3a\u7a7a") @RequestParam(name="id") @NotBlank(message="id \u4e0d\u80fd\u4e3a\u7a7a") String id, @NotNull(message="isEnabled \u4e0d\u80fd\u4e3a\u7a7a") @RequestParam(name="isEnabled") @NotNull(message="isEnabled \u4e0d\u80fd\u4e3a\u7a7a") Integer isEnabled) {
        return this.dynamicFormsService.changeEnabled(id, isEnabled);
    }

    @Log(logOpt=LogEnum.PAGE, module="\u7cfb\u7edf\u52a8\u6001\u8868\u5355")
    @PostMapping(value={"/list"})
    @ApiOperation(value="\u5217\u8868", response=Result.class)
    public Result list(@Validated @RequestBody DynamicFormsListDTO dto) {
        return Result.ok(this.dynamicFormsService.list(dto));
    }
}

