/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.idempotence.interceptor;

import cn.hutool.core.util.StrUtil;
import com.efficient.cache.api.CacheUtil;
import com.efficient.common.result.Result;
import com.efficient.common.result.ResultConstant;
import com.efficient.common.result.ResultEnum;
import com.efficient.common.util.JackSonUtil;
import com.efficient.common.util.WebUtil;
import com.efficient.idempotence.annotation.Idempotence;
import com.efficient.idempotence.properties.IdempotenceProperties;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

@Component
public class IdempotenceInterceptor
implements HandlerInterceptor {
    @Autowired
    private CacheUtil cacheUtil;
    @Autowired
    private IdempotenceProperties properties;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        HandlerMethod method;
        String requestURI = request.getRequestURI();
        String token = request.getHeader("token");
        String ip = WebUtil.getIP((HttpServletRequest)request);
        if (StrUtil.isBlank((CharSequence)token)) {
            token = "not_token";
        }
        StringBuilder sb = new StringBuilder(token);
        String str = sb.append("_").append(ip).append("_").append(requestURI).toString();
        try {
            method = (HandlerMethod)handler;
        }
        catch (ClassCastException e) {
            this.returnJson(response, ResultEnum.ERROR_PATH);
            return false;
        }
        boolean global = this.properties.isGlobal();
        Idempotence idempotence = (Idempotence)method.getMethodAnnotation(Idempotence.class);
        if (global || Objects.nonNull(idempotence)) {
            Long obj = (Long)this.cacheUtil.get("idempotence_cache_", str);
            long currentTimeMillis = System.currentTimeMillis();
            Integer expireTime = this.properties.getExpireTime();
            if (Objects.isNull(expireTime)) {
                expireTime = Objects.isNull(idempotence) ? Integer.valueOf(1) : Integer.valueOf(idempotence.expireTime());
            }
            if (expireTime <= 0) {
                return true;
            }
            if (Objects.nonNull(obj) && currentTimeMillis - obj <= (long)(expireTime * 1000)) {
                this.returnJson(response, ResultEnum.NOT_IDEMPOTENCE);
                this.cacheUtil.put("idempotence_cache_", str, (Object)currentTimeMillis, expireTime.intValue());
                return false;
            }
            this.cacheUtil.put("idempotence_cache_", str, (Object)currentTimeMillis, expireTime.intValue());
        }
        return true;
    }

    private void returnJson(HttpServletResponse response, ResultEnum resultEnum) throws IOException {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json; charset=utf-8");
        PrintWriter out = response.getWriter();
        out.append(JackSonUtil.toJson((Object)Result.build((ResultConstant)resultEnum)));
        out.close();
    }
}

