/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.logs.service;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.efficient.common.auth.RequestHolder;
import com.efficient.common.auth.UserTicket;
import com.efficient.common.util.ThreadUtil;
import com.efficient.logs.annotation.Log;
import com.efficient.logs.api.SysLogService;
import com.efficient.logs.constant.LogEnum;
import com.efficient.logs.dao.SysLogMapper;
import com.efficient.logs.model.entity.SysLog;
import com.efficient.logs.properties.LogsProperties;
import java.util.Date;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(name={"com.efficient.logs.db"}, havingValue="true")
public class SysLogServiceImpl
extends ServiceImpl<SysLogMapper, SysLog>
implements SysLogService {
    @Autowired
    private SysLogMapper sysLogMapper;
    @Autowired
    private LogsProperties logsProperties;
    @Autowired
    private HttpServletRequest request;

    @Override
    public boolean saveLog(Log log, String ip, String url, String params, String resultCode, String result, String exception) {
        UserTicket userTicket = RequestHolder.getCurrUser();
        if (Objects.isNull(userTicket)) {
            userTicket = new UserTicket();
            userTicket.setAccount("unknown");
        }
        SysLog sysLog = new SysLog();
        sysLog.setSystemId(RequestHolder.getCurrSystemId());
        sysLog.setModule(log.module());
        sysLog.setUserId(userTicket.getUserId());
        sysLog.setUserUnitId(userTicket.getUserUnitId());
        sysLog.setUserName(userTicket.getUsername());
        sysLog.setLogIp(ip);
        sysLog.setLogTime(new Date());
        sysLog.setRequestUrl(url);
        LogEnum logEnum = log.logOpt();
        String optText = logEnum.getOpt();
        if (Objects.equals((Object)logEnum, (Object)LogEnum.CUSTOM)) {
            optText = log.customOpt();
        }
        sysLog.setLogOpt(optText);
        String account = userTicket.getAccount();
        String desc = log.desc();
        StringBuilder sb = new StringBuilder(account);
        if (StrUtil.isBlank((CharSequence)desc)) {
            if (log.join()) {
                sb.append(optText);
            }
            if (StrUtil.isNotBlank((CharSequence)log.module())) {
                sb.append(log.module());
            }
            sysLog.setLogContent(sb.toString());
        } else {
            sb.append(desc);
            sysLog.setLogContent(sb.toString());
        }
        sysLog.setParams(params);
        sysLog.setResultCode(resultCode);
        sysLog.setResult(result);
        sysLog.setException(exception);
        return this.save(sysLog);
    }

    @Override
    public void saveLogAsync(Log log, String ip, String url, String params, String resultCode, String result, String exception) {
        ThreadUtil.EXECUTOR_SERVICE.execute(() -> this.saveLog(log, ip, url, params, resultCode, result, exception));
    }
}

