/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.logs.aop;

import com.alibaba.ttl.TransmittableThreadLocal;
import com.efficient.common.auth.RequestHolder;
import com.efficient.common.result.Result;
import com.efficient.common.util.JackSonUtil;
import com.efficient.common.util.ThreadUtil;
import com.efficient.common.util.WebUtil;
import com.efficient.logs.annotation.Log;
import com.efficient.logs.api.SysLogService;
import com.efficient.logs.constant.LogEnum;
import com.efficient.logs.properties.LogsProperties;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.multipart.MultipartFile;

@Aspect
@Component
public class LogsAop {
    public static final TransmittableThreadLocal<Long> START_TIME = new TransmittableThreadLocal();
    private static final Logger LOGGER = LoggerFactory.getLogger(LogsAop.class);
    private static final String REQUEST_NORMAL_FORMAT = "\n=============\nip:%s\nurl:%s\ncontroller:%s\nargs:%s\ntoken:%s\nreturn:%s\ntime:%d\n\u8bf7\u6c42\u6210\u529f\n=============";
    private static final String REQUEST_ERROR_FORMAT = "\n=============\nip:%s\nurl:%s\ncontroller:%s\nargs:%s\ntoken:%s\nreturn:%s\nerror:%s\ntime:%d\n\u8bf7\u6c42\u5931\u8d25\n=============";
    @Autowired
    private HttpServletRequest request;
    @Autowired
    private SysLogService logService;
    @Autowired
    private LogsProperties logsProperties;
    @Autowired
    private ApplicationEventPublisher publisher;

    @Pointcut(value="@annotation(com.efficient.logs.annotation.Log)")
    public void pointCut() {
    }

    @Before(value="pointCut()")
    public void doBefore() {
        START_TIME.set((Object)System.currentTimeMillis());
    }

    @AfterReturning(value="pointCut()", returning="result")
    public void doAfterLog(JoinPoint joinPoint, Object result) {
        this.recordLog(joinPoint, result, null);
    }

    private void recordLog(JoinPoint joinPoint, Object resultValue, Exception exp) {
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        RequestContextHolder.setRequestAttributes((RequestAttributes)servletRequestAttributes, (boolean)true);
        if (Objects.isNull(RequestHolder.getCurrRequest())) {
            RequestHolder.set((HttpServletRequest)this.request);
        }
        ThreadUtil.EXECUTOR_SERVICE.execute(() -> {
            HttpServletRequest request = RequestHolder.getCurrRequest();
            String ip = WebUtil.getIP((HttpServletRequest)request);
            String requestUrl = request.getRequestURI();
            String token = request.getHeader("token");
            try {
                MethodSignature signature = (MethodSignature)joinPoint.getSignature();
                String className = joinPoint.getTarget().getClass().getName();
                Method method = signature.getMethod();
                Log log = method.getAnnotation(Log.class);
                String argsStr = null;
                Object[] args = joinPoint.getArgs();
                if (Objects.equals((Object)log.logOpt(), (Object)LogEnum.IMPORT) && args.length > 0 && args[0] instanceof MultipartFile) {
                    MultipartFile multipartFile = (MultipartFile)args[0];
                    argsStr = multipartFile.getOriginalFilename();
                } else {
                    argsStr = JackSonUtil.toJson((Object)args);
                }
                long endTime = System.currentTimeMillis();
                String resultCode = "-1";
                String returnValue = JackSonUtil.toJson((Object)resultValue);
                String expStr = null;
                if (resultValue instanceof Result) {
                    Result result = (Result)resultValue;
                    resultCode = String.valueOf(result.getCode());
                }
                if (Objects.nonNull(exp)) {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    exp.printStackTrace(pw);
                    pw.close();
                    expStr = sw.toString();
                    LOGGER.error(String.format(REQUEST_ERROR_FORMAT, ip, requestUrl, className, argsStr, token, "\u65e0", sw, 0L), (Throwable)exp);
                } else {
                    LOGGER.info(String.format(REQUEST_NORMAL_FORMAT, ip, requestUrl, className, argsStr, token, returnValue, endTime - (Long)START_TIME.get()));
                }
                if (this.logsProperties.isDb() && Objects.nonNull(log)) {
                    this.logService.saveLog(log, ip, requestUrl, argsStr, resultCode, returnValue, expStr);
                }
            }
            catch (Exception e) {
                LOGGER.error("\u65e5\u5fd7\u8bb0\u5f55\u5f02\u5e38\uff1a", (Throwable)e);
            }
        });
    }

    @AfterThrowing(value="pointCut()", throwing="exp")
    public void doAfterThrowing(JoinPoint joinPoint, Exception exp) {
        this.recordLog(joinPoint, null, exp);
    }
}

