/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.logs.controller;

import com.efficient.common.permission.Permission;
import com.efficient.common.result.Result;
import com.efficient.logs.annotation.Log;
import com.efficient.logs.api.SysLogService;
import com.efficient.logs.constant.LogEnum;
import com.efficient.logs.model.dto.SysLogListDTO;
import com.efficient.logs.model.vo.SysLogVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.validation.constraints.NotBlank;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sysLog"})
@Validated
@Api(tags={"\u65e5\u5fd7\u7ba1\u7406"})
@Permission
public class SysLogController {
    @Autowired
    private SysLogService sysLogService;

    @Log(logOpt=LogEnum.PAGE, module="\u65e5\u5fd7\u7ba1\u7406")
    @PostMapping(value={"/list"})
    @ApiOperation(value="\u5217\u8868", response=SysLogVO.class)
    public Result list(@Validated @RequestBody SysLogListDTO dto) {
        return Result.ok(this.sysLogService.list(dto));
    }

    @Log(logOpt=LogEnum.QUERY, module="\u65e5\u5fd7\u7ba1\u7406")
    @PostMapping(value={"/find"})
    @ApiOperation(value="\u67e5\u627e", response=SysLogVO.class)
    public Result find(@NotBlank(message="id \u4e0d\u80fd\u4e3a\u7a7a") @RequestParam(name="id") @NotBlank(message="id \u4e0d\u80fd\u4e3a\u7a7a") String id) {
        return Result.ok((Object)this.sysLogService.find(id));
    }
}

