/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.logs.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.efficient.common.auth.RequestHolder;
import com.efficient.common.auth.UserTicket;
import com.efficient.common.constant.CommonConstant;
import com.efficient.common.result.ResultEnum;
import com.efficient.common.util.ThreadUtil;
import com.efficient.logs.annotation.Log;
import com.efficient.logs.api.SysLogService;
import com.efficient.logs.constant.LogEnum;
import com.efficient.logs.dao.SysLogMapper;
import com.efficient.logs.model.converter.SysLogConverter;
import com.efficient.logs.model.dto.SysLogListDTO;
import com.efficient.logs.model.entity.SysLog;
import com.efficient.logs.model.vo.SysLogVO;
import com.efficient.logs.properties.LogsProperties;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(name={"com.efficient.logs.db"}, havingValue="true")
public class SysLogServiceImpl
extends ServiceImpl<SysLogMapper, SysLog>
implements SysLogService {
    @Autowired
    private SysLogMapper sysLogMapper;
    @Autowired
    private LogsProperties logsProperties;
    @Autowired
    private HttpServletRequest request;
    @Autowired
    private SysLogConverter sysLogConverter;

    @Override
    public boolean saveLog(Log log, String ip, String url, String params, String resultCode, String result, String exception) {
        UserTicket userTicket = RequestHolder.getCurrUser();
        if (Objects.isNull(userTicket)) {
            userTicket = new UserTicket();
            userTicket.setAccount("unknown");
        }
        SysLog sysLog = new SysLog();
        sysLog.setSystemId(RequestHolder.getCurrSystemId());
        sysLog.setModule(log.module());
        sysLog.setUserId(userTicket.getUserId());
        sysLog.setUserUnitId(userTicket.getUserUnitId());
        sysLog.setUserName(userTicket.getUsername());
        sysLog.setLogIp(ip);
        sysLog.setLogTime(new Date());
        sysLog.setRequestUrl(url);
        LogEnum logEnum = log.logOpt();
        String optText = logEnum.getOpt();
        if (Objects.equals((Object)logEnum, (Object)LogEnum.CUSTOM)) {
            optText = log.customOpt();
        }
        sysLog.setLogOpt(optText);
        String account = userTicket.getAccount();
        String desc = log.desc();
        StringBuilder sb = new StringBuilder(account);
        if (StrUtil.isBlank((CharSequence)desc)) {
            if (log.join()) {
                sb.append(optText);
            }
            if (StrUtil.isNotBlank((CharSequence)log.module())) {
                sb.append(log.module());
            }
            sysLog.setLogContent(sb.toString());
        } else {
            sb.append(desc);
            sysLog.setLogContent(sb.toString());
        }
        sysLog.setParams(params);
        sysLog.setResultCode(resultCode);
        sysLog.setResult(result);
        sysLog.setException(exception);
        return this.save(sysLog);
    }

    @Override
    public void saveLogAsync(Log log, String ip, String url, String params, String resultCode, String result, String exception) {
        ThreadUtil.EXECUTOR_SERVICE.execute(() -> this.saveLog(log, ip, url, params, resultCode, result, exception));
    }

    @Override
    public Page<SysLogVO> list(SysLogListDTO dto) {
        Integer logType;
        Date endDate;
        Date startDate;
        Integer isSuccess;
        String module;
        String logOpt;
        String userName;
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.select(new SFunction[]{SysLog::getId, SysLog::getSystemId, SysLog::getModule, SysLog::getUserId, SysLog::getUserName, SysLog::getLogIp, SysLog::getLogTime, SysLog::getLogOpt, SysLog::getLogContent, SysLog::getResultCode});
        String systemId = dto.getSystemId();
        if (StrUtil.isNotBlank((CharSequence)systemId)) {
            queryWrapper.eq(SysLog::getSystemId, (Object)systemId);
        }
        if (StrUtil.isNotBlank((CharSequence)(userName = dto.getUserName()))) {
            queryWrapper.like(SysLog::getUserName, (Object)userName);
        }
        if (StrUtil.isNotBlank((CharSequence)(logOpt = dto.getLogOpt()))) {
            queryWrapper.eq(SysLog::getLogOpt, (Object)logOpt);
        }
        String logContent = dto.getLogContent();
        if (StrUtil.isNotBlank((CharSequence)logOpt)) {
            queryWrapper.like(SysLog::getLogContent, (Object)logContent);
        }
        if (StrUtil.isNotBlank((CharSequence)(module = dto.getModule()))) {
            queryWrapper.eq(SysLog::getModule, (Object)module);
        }
        String logIp = dto.getLogIp();
        if (StrUtil.isNotBlank((CharSequence)module)) {
            queryWrapper.like(SysLog::getLogIp, (Object)logIp);
        }
        if (Objects.nonNull(isSuccess = dto.getIsSuccess())) {
            if (Objects.equals(isSuccess, CommonConstant.TRUE_INT)) {
                queryWrapper.eq(SysLog::getResultCode, (Object)ResultEnum.SUCCESS.getCode());
            } else {
                queryWrapper.ne(SysLog::getResultCode, (Object)ResultEnum.SUCCESS.getCode());
            }
        }
        if (Objects.nonNull(startDate = dto.getStartDate())) {
            queryWrapper.ge(SysLog::getLogTime, (Object)DateUtil.beginOfDay((Date)startDate));
        }
        if (Objects.nonNull(endDate = dto.getEndDate())) {
            queryWrapper.le(SysLog::getLogTime, (Object)DateUtil.endOfDay((Date)endDate));
        }
        if (Objects.nonNull(logType = dto.getLogType())) {
            if (Objects.equals(logType, CommonConstant.TRUE_INT)) {
                queryWrapper.eq(SysLog::getLogOpt, (Object)LogEnum.LOGIN.getOpt());
            } else {
                queryWrapper.ne(SysLog::getLogOpt, (Object)LogEnum.LOGIN.getOpt());
            }
        }
        queryWrapper.orderByDesc(SysLog::getLogTime);
        Page sysLogPage = new Page((long)dto.getPageNum().intValue(), (long)dto.getPageSize().intValue());
        Page page = (Page)this.page((IPage)sysLogPage, (Wrapper)queryWrapper);
        ArrayList voList = new ArrayList();
        List records = page.getRecords();
        Page resultPage = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        resultPage.setRecords(voList);
        if (CollUtil.isEmpty((Collection)records)) {
            return resultPage;
        }
        records.forEach(et -> {
            SysLogVO sysLogVO = this.sysLogConverter.entity2Vo((SysLog)et);
            voList.add(sysLogVO);
        });
        return resultPage;
    }

    @Override
    public SysLog find(String id) {
        SysLog byId = (SysLog)this.getById((Serializable)((Object)id));
        return byId;
    }
}

