/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.logs.handle;

import cn.hutool.core.util.StrUtil;
import com.efficient.logs.api.LogFunctionService;
import com.efficient.logs.handle.OperateLogExpressionEvaluator;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.expression.AnnotatedElementKey;
import org.springframework.expression.EvaluationContext;
import org.springframework.stereotype.Component;

@Component
public class LogSpelProcess {
    private static final Logger log = LoggerFactory.getLogger(LogSpelProcess.class);
    private static final Pattern PATTERN_ATTRIBUTE = Pattern.compile("\\{(.*?)}");
    private static final Pattern PATTERN_METHOD = Pattern.compile("\\[(.*?)]");
    private final OperateLogExpressionEvaluator cachedExpressionEvaluator = new OperateLogExpressionEvaluator();
    @Autowired
    private LogFunctionService logFunctionService;

    public HashMap<String, String> processBeforeExec(List<String> templates, JoinPoint joinPoint) {
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        Method method = methodSignature.getMethod();
        Object[] args = joinPoint.getArgs();
        Object target = joinPoint.getTarget();
        Class targetClass = AopUtils.getTargetClass((Object)target);
        HashMap<String, String> map = new HashMap<String, String>();
        AnnotatedElementKey elementKey = new AnnotatedElementKey((AnnotatedElement)method, targetClass);
        EvaluationContext evaluationContext = this.cachedExpressionEvaluator.createEvaluationContext(targetClass, method, args);
        for (String template : templates) {
            String str;
            Object value;
            String paramName;
            map.put(template, template);
            if (template.contains("[")) {
                Matcher matcher = PATTERN_METHOD.matcher(template);
                while (matcher.find()) {
                    String funcName = matcher.group(1);
                    Matcher patternAttribute = PATTERN_ATTRIBUTE.matcher(funcName);
                    paramName = null;
                    if (patternAttribute.find()) {
                        paramName = patternAttribute.group(1);
                    }
                    if (!this.logFunctionService.executeBefore(funcName = StrUtil.subBefore((CharSequence)funcName, (CharSequence)"{", (boolean)Boolean.FALSE))) continue;
                    value = this.cachedExpressionEvaluator.parseExpression(paramName, elementKey, evaluationContext);
                    String apply = this.logFunctionService.apply(funcName, value == null ? null : value.toString());
                    String str2 = matcher.replaceAll(apply);
                    map.put(template, str2);
                }
            }
            if (!(str = map.get(template)).contains("{")) continue;
            Matcher matcher = PATTERN_ATTRIBUTE.matcher(str);
            StringBuffer bufferStr = new StringBuffer();
            while (matcher.find()) {
                paramName = matcher.group(1);
                value = this.cachedExpressionEvaluator.parseExpression(paramName, elementKey, evaluationContext);
                matcher.appendReplacement(bufferStr, value.toString());
            }
            matcher.appendTail(bufferStr);
            map.put(template, bufferStr.toString());
        }
        return map;
    }

    public HashMap<String, String> ternaryProcess(HashMap<String, String> map, JoinPoint joinPoint) {
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        Method method = methodSignature.getMethod();
        Object[] args = joinPoint.getArgs();
        Object target = joinPoint.getTarget();
        Class targetClass = AopUtils.getTargetClass((Object)target);
        EvaluationContext evaluationContext = this.cachedExpressionEvaluator.createEvaluationContext(targetClass, method, args);
        Set<Map.Entry<String, String>> entries = map.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            String key = entry.getKey();
            if (!key.contains("?") && !key.contains(":")) continue;
            String value = entry.getValue();
            try {
                AnnotatedElementKey annotatedElementKey = new AnnotatedElementKey((AnnotatedElement)method, targetClass);
                value = this.cachedExpressionEvaluator.parseExpression(evaluationContext, annotatedElementKey, value);
                map.put(key, value);
            }
            catch (Exception e) {
                log.info("\u89e3\u6790\u64cd\u4f5c\u65e5\u5fd7SpEL\u51fa\u9519 ={}", (Object)e.getMessage());
            }
        }
        return map;
    }
}

