/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.openapi.service;

import cn.hutool.core.date.DateUtil;
import com.efficient.auth.api.AuthService;
import com.efficient.cache.api.CacheUtil;
import com.efficient.common.auth.RequestHolder;
import com.efficient.common.auth.UserTicket;
import com.efficient.common.result.Result;
import com.efficient.common.util.AESUtils;
import com.efficient.common.util.IdUtil;
import com.efficient.common.util.JackSonUtil;
import com.efficient.common.util.RsaUtil;
import com.efficient.openapi.api.OpenApiService;
import com.efficient.openapi.entity.OpenApiAccessTokenRequest;
import com.efficient.openapi.entity.OpenApiToken;
import com.efficient.openapi.properties.OpenApiProperties;
import com.efficient.system.api.SysApplicationService;
import com.efficient.system.model.vo.SysApplicationVO;
import java.util.Date;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OpenApiServiceImpl
implements OpenApiService {
    @Autowired
    private SysApplicationService applicationService;
    @Autowired
    private CacheUtil cacheUtil;
    @Autowired
    private OpenApiProperties openApiProperties;
    @Autowired
    private AuthService authService;

    @Override
    public Result<String> getAccessToken(OpenApiAccessTokenRequest tokenRequest) {
        Result result = this.applicationService.findByAppCode(tokenRequest.getAppCode());
        if (!Objects.equals(result.getCode(), Result.ok().getCode())) {
            return Result.fail((Object)result.getMsg());
        }
        String accessToken = IdUtil.generateBatchNumber();
        this.cacheUtil.put("system-cache-accessToken", accessToken, (Object)tokenRequest, this.openApiProperties.getTimeToIdle() * 60);
        return Result.ok((Object)accessToken);
    }

    @Override
    public Result<String> getUserInfo() {
        String accessToken = RequestHolder.getCurrRequest().getHeader("accessToken");
        if (Objects.isNull(accessToken)) {
            return Result.fail((Object)"Header \u7f3a\u5931\u53c2\u6570: accessToken");
        }
        String token = RequestHolder.getCurrRequest().getHeader("token");
        if (Objects.isNull(token)) {
            return Result.fail((Object)"Header \u7f3a\u5931\u53c2\u6570: token");
        }
        Object object = this.cacheUtil.get("system-cache-accessToken", accessToken);
        if (Objects.isNull(object)) {
            return Result.fail((Object)"accessToken\u5df2\u8fc7\u671f\uff01");
        }
        String encrypt = AESUtils.decrypt((String)token);
        OpenApiToken openApiToken = (OpenApiToken)JackSonUtil.toObject((String)encrypt, OpenApiToken.class);
        long createTime = openApiToken.getCreateTime();
        if (createTime <= 0L || DateUtil.offsetMinute((Date)new Date(), (int)(-this.openApiProperties.getTimeToIdle().intValue())).getTime() - createTime > 0L) {
            return Result.fail((Object)"token\u5df2\u8fc7\u671f\uff01");
        }
        Result result = this.applicationService.findByAppCode(openApiToken.getAppCode());
        if (!Objects.equals(result.getCode(), Result.ok().getCode())) {
            return Result.fail((Object)result.getMsg());
        }
        SysApplicationVO sysApplicationVO = (SysApplicationVO)result.getData();
        UserTicket userTicket = this.authService.getOpenApiUserInfo(openApiToken.getUserId());
        if (Objects.isNull(userTicket)) {
            return Result.fail((Object)"\u672a\u67e5\u627e\u5230\u7528\u6237\u4fe1\u606f\uff01");
        }
        String encryptedReversal = RsaUtil.encryptReversal((String)JackSonUtil.toJson((Object)userTicket), (String)sysApplicationVO.getAppSecret());
        return Result.ok((Object)encryptedReversal);
    }

    @Override
    public Result<String> createToken(String userId, String appCode) {
        Result result = this.applicationService.findByAppCode(appCode);
        if (!Objects.equals(result.getCode(), Result.ok().getCode())) {
            return Result.fail((Object)result.getMsg());
        }
        OpenApiToken openApiToken = new OpenApiToken();
        openApiToken.setUserId(userId);
        openApiToken.setCreateTime(new Date().getTime());
        openApiToken.setAppCode(appCode);
        String encrypt = AESUtils.encrypt((String)JackSonUtil.toJson((Object)openApiToken));
        return Result.ok((Object)encrypt);
    }
}

