/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.openapi.controller;

import com.efficient.common.result.Result;
import com.efficient.common.validate.QueryGroup;
import com.efficient.logs.annotation.Log;
import com.efficient.logs.constant.LogEnum;
import com.efficient.openapi.api.OpenApiService;
import com.efficient.openapi.entity.OpenApiAccessTokenRequest;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.validation.constraints.NotBlank;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/openApi"})
@Validated
@Api(tags={"openApi"})
public class OpenApiController {
    @Autowired
    private OpenApiService openApiService;

    @Log(logOpt=LogEnum.QUERY, module="\u7cfb\u7edf\u7b2c\u4e09\u65b9\u5e94\u7528")
    @GetMapping(value={"/createToken"})
    @ApiOperation(value="createToken")
    public Result<String> createToken(@NotBlank(message="userId \u4e0d\u80fd\u4e3a\u7a7a") @RequestParam(value="userId") @NotBlank(message="userId \u4e0d\u80fd\u4e3a\u7a7a") String userId, @NotBlank(message="appCode \u4e0d\u80fd\u4e3a\u7a7a") @RequestParam(value="appCode") @NotBlank(message="appCode \u4e0d\u80fd\u4e3a\u7a7a") String appCode) {
        return this.openApiService.createToken(userId, appCode);
    }

    @Log(logOpt=LogEnum.QUERY, module="\u7cfb\u7edf\u7b2c\u4e09\u65b9\u5e94\u7528")
    @PostMapping(value={"/getAccessToken"})
    @ApiOperation(value="\u83b7\u53d6accessToken")
    public Result<String> getAccessToken(@Validated(value={QueryGroup.class}) @RequestBody OpenApiAccessTokenRequest tokenRequest) {
        return this.openApiService.getAccessToken(tokenRequest);
    }

    @Log(logOpt=LogEnum.QUERY, module="\u7cfb\u7edf\u7b2c\u4e09\u65b9\u5e94\u7528")
    @GetMapping(value={"/getUserInfo"})
    @ApiOperation(value="\u83b7\u53d6accessToken")
    public Result<String> getUserInfo() {
        return this.openApiService.getUserInfo();
    }
}

