/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.rate.interceptor;

import cn.hutool.core.util.StrUtil;
import com.efficient.cache.api.CacheUtil;
import com.efficient.common.result.ResultConstant;
import com.efficient.common.result.ResultEnum;
import com.efficient.common.util.RenderJson;
import com.efficient.common.util.WebUtil;
import com.efficient.rate.annotation.RateLimit;
import com.efficient.rate.properties.RateProperties;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

@Component
public class RateInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(RateInterceptor.class);
    @Autowired
    private CacheUtil cacheUtil;
    @Autowired
    private RateProperties properties;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        long expireTime;
        HandlerMethod method;
        boolean enable = this.properties.isEnable();
        if (!enable) {
            return true;
        }
        String servletPath = request.getServletPath();
        String token = request.getHeader("token");
        String ip = WebUtil.getIP((HttpServletRequest)request);
        if (StrUtil.isBlank((CharSequence)token)) {
            token = "not_token";
        }
        String str = token + "_" + ip + "_" + servletPath;
        try {
            method = (HandlerMethod)handler;
        }
        catch (ClassCastException e) {
            RenderJson.returnJson((HttpServletResponse)response, (ResultConstant)ResultEnum.ERROR_PATH);
            return false;
        }
        boolean global = this.properties.isGlobal();
        RateLimit idempotence = (RateLimit)method.getMethodAnnotation(RateLimit.class);
        if (global) {
            expireTime = this.properties.getExpireTime();
        } else if (Objects.nonNull(idempotence)) {
            expireTime = idempotence.expireTime();
        } else {
            return true;
        }
        if (expireTime <= 0L) {
            return true;
        }
        Long obj = (Long)this.cacheUtil.get("rate_cache", str);
        long currentTimeMillis = System.currentTimeMillis();
        if (Objects.nonNull(obj) && currentTimeMillis - obj <= expireTime * 1000L) {
            this.cacheUtil.put("rate_cache", str, (Object)currentTimeMillis, (int)expireTime);
            RenderJson.returnJson((HttpServletResponse)response, (ResultConstant)ResultEnum.NOT_IDEMPOTENCE);
            return false;
        }
        this.cacheUtil.put("rate_cache", str, (Object)currentTimeMillis, (int)expireTime);
        return true;
    }
}

