/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.rate.interceptor;

import cn.hutool.core.util.StrUtil;
import com.efficient.cache.api.CacheUtil;
import com.efficient.common.result.Result;
import com.efficient.common.result.ResultConstant;
import com.efficient.common.result.ResultEnum;
import com.efficient.common.util.JackSonUtil;
import com.efficient.common.util.WebUtil;
import com.efficient.rate.annotation.RateLimit;
import com.efficient.rate.properties.RateProperties;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

@Component
public class RateInterceptor
implements HandlerInterceptor {
    @Autowired
    private CacheUtil cacheUtil;
    @Autowired
    private RateProperties properties;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        long expireTime;
        HandlerMethod method;
        boolean enable = this.properties.isEnable();
        if (!enable) {
            return true;
        }
        String requestURI = request.getRequestURI();
        String token = request.getHeader("token");
        String ip = WebUtil.getIP((HttpServletRequest)request);
        if (StrUtil.isBlank((CharSequence)token)) {
            token = "not_token";
        }
        StringBuilder sb = new StringBuilder(token);
        String str = sb.append("_").append(ip).append("_").append(requestURI).toString();
        try {
            method = (HandlerMethod)handler;
        }
        catch (ClassCastException e) {
            this.returnJson(response, ResultEnum.ERROR_PATH);
            return false;
        }
        boolean global = this.properties.isGlobal();
        RateLimit idempotence = (RateLimit)method.getMethodAnnotation(RateLimit.class);
        if (global) {
            expireTime = this.properties.getExpireTime();
        } else if (Objects.nonNull(idempotence)) {
            expireTime = idempotence.expireTime();
        } else {
            return true;
        }
        if (expireTime <= 0L) {
            return true;
        }
        Long obj = (Long)this.cacheUtil.get("idempotence_cache_", str);
        long currentTimeMillis = System.currentTimeMillis();
        if (Objects.nonNull(obj) && currentTimeMillis - obj <= expireTime) {
            this.returnJson(response, ResultEnum.NOT_IDEMPOTENCE);
            this.cacheUtil.put("idempotence_cache_", str, (Object)currentTimeMillis, (int)(expireTime / 1000L));
            return false;
        }
        this.cacheUtil.put("idempotence_cache_", str, (Object)currentTimeMillis, (int)(expireTime / 1000L));
        return true;
    }

    private void returnJson(HttpServletResponse response, ResultEnum resultEnum) throws IOException {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json; charset=utf-8");
        PrintWriter out = response.getWriter();
        out.append(JackSonUtil.toJson((Object)Result.build((ResultConstant)resultEnum)));
        out.close();
    }
}

