/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.rate.config;

import cn.hutool.core.collection.CollUtil;
import com.efficient.rate.interceptor.RateInterceptor;
import com.efficient.rate.properties.RateProperties;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class RateWebMvcConfig
implements WebMvcConfigurer {
    private static final Logger log = LoggerFactory.getLogger(RateWebMvcConfig.class);
    @Autowired
    private RateInterceptor rateInterceptor;
    @Autowired
    private RateProperties rateProperties;

    public void addInterceptors(InterceptorRegistry registry) {
        List<String> methodList = this.rateProperties.getMethodList();
        List<String> excludeApiList = this.rateProperties.getExcludeApiList();
        if (CollUtil.isEmpty(excludeApiList)) {
            registry.addInterceptor((HandlerInterceptor)this.rateInterceptor).addPathPatterns(methodList);
        } else {
            registry.addInterceptor((HandlerInterceptor)this.rateInterceptor).addPathPatterns(methodList).excludePathPatterns(excludeApiList);
        }
    }
}

