/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.swagger.config;

import com.efficient.swagger.properties.SwaggerProperties;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@Configuration
@EnableSwagger2
@EnableConfigurationProperties(value={SwaggerProperties.class})
@ConditionalOnProperty(name={"com.efficient.swagger.enable"}, havingValue="true")
public class SwaggerConfig {
    @Autowired
    private SwaggerProperties swaggerProperties;

    @Bean
    @ConditionalOnMissingBean
    public Docket createRestApi() {
        return new Docket(DocumentationType.SWAGGER_2).apiInfo(this.apiInfo()).enable(this.swaggerProperties.getEnable().booleanValue()).select().apis(RequestHandlerSelectors.withMethodAnnotation(ApiOperation.class)).paths(Predicates.not((Predicate)PathSelectors.regex((String)"/error.*"))).paths(PathSelectors.any()).build();
    }

    private ApiInfo apiInfo() {
        return new ApiInfoBuilder().title(this.swaggerProperties.getTitle()).description(this.swaggerProperties.getDescription()).termsOfServiceUrl(this.swaggerProperties.getTermsOfServiceUrl()).version(this.swaggerProperties.getVersion()).build();
    }
}

