/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.swagger.service;

import com.efficient.common.api.StartedEventServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@ConditionalOnProperty(name={"com.efficient.swagger.enable"}, havingValue="true")
@Service
public class SwaggerStartedEvent
implements StartedEventServer {
    private static final Logger log = LoggerFactory.getLogger(SwaggerStartedEvent.class);
    @Value(value="${server.port:8080}")
    private Integer port;
    @Value(value="${server.servlet.context-path:}")
    private String contextPath;

    public void init() {
        String serverAddress = "http://localhost:" + this.port + this.contextPath + "/swagger-ui/index.html";
        log.info("swagger doc url: {}", (Object)serverAddress);
    }
}

