/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.system.service;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.efficient.system.api.SysUnitService;
import com.efficient.system.constant.SystemConstant;
import com.efficient.system.dao.SysUnitMapper;
import com.efficient.system.model.converter.SysUnitConverter;
import com.efficient.system.model.entity.SysUnit;
import java.io.Serializable;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysUnitServiceImpl
extends ServiceImpl<SysUnitMapper, SysUnit>
implements SysUnitService {
    private static final Logger log = LoggerFactory.getLogger(SysUnitServiceImpl.class);
    @Autowired
    private SysUnitConverter sysUnitConverter;
    @Autowired
    private SysUnitMapper sysUnitMapper;

    @Override
    public synchronized String createLevelCode(String parentId) {
        SysUnit sysUnit = (SysUnit)this.getById((Serializable)((Object)parentId));
        if (Objects.isNull(sysUnit)) {
            SysUnit sysUnitLast = this.sysUnitMapper.findLastUnitByLength(SystemConstant.UNIT_LEVEL_COUNT);
            if (Objects.isNull(sysUnitLast)) {
                return "500";
            }
            String levelCode = sysUnitLast.getLevelCode();
            return this.getNextLevelCode(levelCode);
        }
        SysUnit sysUnitLast = this.sysUnitMapper.findLastUnitByParentId(parentId);
        if (Objects.isNull(sysUnitLast)) {
            return sysUnit.getLevelCode() + "001";
        }
        String levelCode = sysUnitLast.getLevelCode();
        return this.getNextLevelCode(levelCode);
    }

    private String getNextLevelCode(String levelCode) {
        String substring = levelCode.substring(levelCode.length() - 3);
        int next = Integer.parseInt(substring) + 1;
        String format = String.format("%03d", next);
        return levelCode.substring(0, levelCode.length() - 3) + format;
    }

    @Override
    public String getBelongById(String id) {
        return this.sysUnitMapper.getBelongById(id);
    }

    @Override
    public SysUnit getByOrgCode(String organizationCode) {
        return this.sysUnitMapper.getByOrgCode(organizationCode);
    }

    @Override
    public SysUnit getUnitByDeptId(String deptId) {
        return this.sysUnitMapper.getUnitByDeptId(deptId);
    }
}

