/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.system.service;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.efficient.common.entity.KeyPair;
import com.efficient.common.result.Result;
import com.efficient.common.util.IdUtil;
import com.efficient.common.util.RsaUtil;
import com.efficient.system.api.SysApplicationService;
import com.efficient.system.dao.SysApplicationMapper;
import com.efficient.system.model.converter.SysApplicationConverter;
import com.efficient.system.model.dto.SysApplicationDTO;
import com.efficient.system.model.dto.SysApplicationListDTO;
import com.efficient.system.model.entity.SysApplication;
import com.efficient.system.model.vo.SysApplicationVO;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysApplicationServiceImpl
extends ServiceImpl<SysApplicationMapper, SysApplication>
implements SysApplicationService {
    @Autowired
    private SysApplicationConverter sysApplicationConverter;
    @Autowired
    private SysApplicationMapper sysApplicationMapper;

    @Override
    public Result<SysApplication> save(SysApplicationDTO dto) {
        SysApplication entity = this.sysApplicationConverter.dto2Entity(dto);
        entity.setAppCode(IdUtil.generateCode());
        KeyPair keyPair = RsaUtil.generateKeyPair();
        entity.setAppKey(keyPair.getPublicKey());
        entity.setAppSecret(keyPair.getPrivateKey());
        boolean flag = this.save(entity);
        return Result.ok((Object)entity);
    }

    @Override
    public Result<Boolean> update(SysApplicationDTO dto) {
        boolean flag = this.updateById(this.sysApplicationConverter.dto2Entity(dto));
        return flag ? Result.ok() : Result.fail();
    }

    @Override
    public Result<Boolean> delete(String id) {
        boolean flag = this.removeById((Serializable)((Object)id));
        return flag ? Result.ok() : Result.fail();
    }

    @Override
    public Page<SysApplication> list(SysApplicationListDTO dto) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper(SysApplication.class);
        Page page = (Page)this.sysApplicationMapper.selectPage((IPage)new Page((long)dto.getPageNum().intValue(), (long)dto.getPageSize().intValue()), (Wrapper)queryWrapper);
        return page;
    }

    @Override
    public Result<SysApplicationVO> findByAppCode(String appCode) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysApplication::getAppCode, (Object)appCode);
        queryWrapper.last(" limit 1");
        SysApplication sysApplication = (SysApplication)this.sysApplicationMapper.selectOne((Wrapper)queryWrapper);
        SysApplicationVO vo = this.sysApplicationConverter.entity2Vo(sysApplication);
        return Result.ok((Object)vo);
    }
}

