/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.system.service;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.efficient.common.constant.CommonConstant;
import com.efficient.common.result.Result;
import com.efficient.common.util.JackSonUtil;
import com.efficient.system.api.SysConfigService;
import com.efficient.system.dao.SysConfigMapper;
import com.efficient.system.model.converter.SysConfigConverter;
import com.efficient.system.model.dto.SysConfigDTO;
import com.efficient.system.model.entity.SysConfig;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysConfigServiceImpl
extends ServiceImpl<SysConfigMapper, SysConfig>
implements SysConfigService {
    @Autowired
    private SysConfigConverter sysConfigConverter;
    @Autowired
    private SysConfigMapper sysConfigMapper;

    @Override
    public Result<SysConfig> save(SysConfigDTO dto) {
        SysConfig entity = this.sysConfigConverter.dto2Entity(dto);
        boolean flag = this.save(entity);
        return Result.ok((Object)entity);
    }

    @Override
    public <T> T findByCode(String code, Class<T> tClass) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysConfig::getCode, (Object)code);
        queryWrapper.eq(SysConfig::getIsEnable, (Object)CommonConstant.TRUE_INT);
        queryWrapper.last(" limit 1");
        SysConfig sysConfig = (SysConfig)this.sysConfigMapper.selectOne((Wrapper)queryWrapper);
        if (Objects.isNull(sysConfig)) {
            return null;
        }
        return (T)JackSonUtil.toObject((String)sysConfig.getConfig(), tClass);
    }
}

