/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.system.service;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.efficient.cache.api.CacheUtil;
import com.efficient.common.constant.CommonConstant;
import com.efficient.common.entity.TreeNode;
import com.efficient.common.util.CollUtil;
import com.efficient.common.util.TreeUtil;
import com.efficient.system.api.DictCodeService;
import com.efficient.system.dao.DictCodeMapper;
import com.efficient.system.model.converter.DictCodeConverter;
import com.efficient.system.model.entity.DictCode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DictCodeServiceImpl
extends ServiceImpl<DictCodeMapper, DictCode>
implements DictCodeService {
    private static final Logger log = LoggerFactory.getLogger(DictCodeServiceImpl.class);
    @Autowired
    private DictCodeConverter dictCodeConverter;
    @Autowired
    private DictCodeMapper dictCodeMapper;
    @Autowired
    private CacheUtil cacheUtil;

    @Override
    public List<DictCode> findByType(String type) {
        List list = (List)this.cacheUtil.get("dict-cache", type);
        if (cn.hutool.core.collection.CollUtil.isEmpty((Collection)list)) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(DictCode::getIsEnable, (Object)CommonConstant.TRUE_INT);
            queryWrapper.eq(DictCode::getCodeType, (Object)type);
            queryWrapper.orderByAsc(DictCode::getSort);
            list = this.list((Wrapper)queryWrapper);
            this.cacheUtil.put("dict-cache", type, (Object)list);
        }
        return list;
    }

    @Override
    public Map<String, String> findMapByType(String type) {
        List<DictCode> list = this.findByType(type);
        if (cn.hutool.core.collection.CollUtil.isEmpty(list)) {
            return new HashMap<String, String>();
        }
        return list.stream().collect(Collectors.toMap(DictCode::getCode, DictCode::getCodeName, (k1, k2) -> k1));
    }

    @Override
    public Map<String, String> findReversalMapByType(String type) {
        Map<String, String> mapByType = this.findMapByType(type);
        return CollUtil.reverseMap(mapByType);
    }

    @Override
    public void init() {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(DictCode::getIsEnable, (Object)CommonConstant.TRUE_INT);
        ((LambdaQueryWrapper)queryWrapper.orderByAsc(DictCode::getCodeType)).orderByAsc(DictCode::getSort);
        List list = this.list((Wrapper)queryWrapper);
        if (cn.hutool.core.collection.CollUtil.isEmpty((Collection)list)) {
            return;
        }
        Map<String, List<DictCode>> listMap = list.stream().collect(Collectors.groupingBy(DictCode::getCodeType));
        listMap.forEach((k, v) -> this.cacheUtil.put("dict-cache", k, v));
        log.info("load dict success!");
    }

    @Override
    public List<TreeNode> findTree(String type) {
        List<DictCode> list = this.findByType(type);
        if (cn.hutool.core.collection.CollUtil.isEmpty(list)) {
            return new ArrayList<TreeNode>();
        }
        ArrayList treeNodeList = new ArrayList();
        list.forEach(et -> {
            TreeNode treeNode = TreeNode.builder().id(et.getCode()).code(et.getCode()).parentId(et.getParentCode()).order(et.getSort()).name(et.getCodeName()).isRoot(Boolean.valueOf(StrUtil.equals((CharSequence)et.getParentCode(), (CharSequence)"-1"))).build();
            treeNodeList.add(treeNode);
        });
        return TreeUtil.createListTree(treeNodeList);
    }
}

