/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.task.service;

import com.efficient.task.api.SysTaskService;
import com.efficient.task.api.TaskExecuteService;
import com.efficient.task.constant.TaskResultEnum;
import com.efficient.task.constant.TaskStatusEnum;
import com.efficient.task.model.entity.SysTask;
import com.sjr.common.result.Result;
import com.sjr.common.result.ResultConstant;
import java.io.Serializable;
import java.util.Objects;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TaskExecuteServiceImpl
implements TaskExecuteService {
    @Autowired
    private SysTaskService sysTaskService;
    @Autowired
    private Scheduler scheduler;

    @Override
    public Result start(String taskId) throws Exception {
        SysTask sysTask = (SysTask)this.sysTaskService.getById((Serializable)((Object)taskId));
        if (Objects.isNull(sysTask)) {
            return Result.build((ResultConstant)TaskResultEnum.NOT_CHECK_FILE);
        }
        JobKey jobKey = new JobKey(sysTask.getTaskCode(), "job");
        if (this.scheduler.checkExists(jobKey)) {
            this.scheduler.deleteJob(jobKey);
        }
        JobDetail taskTest = JobBuilder.newJob(Class.forName(sysTask.getTaskClass())).withIdentity(sysTask.getTaskCode(), "job").storeDurably().build();
        CronScheduleBuilder cronScheduleBuilder = CronScheduleBuilder.cronSchedule((String)sysTask.getCronExpression());
        CronTrigger build = (CronTrigger)TriggerBuilder.newTrigger().forJob(taskTest).withIdentity(sysTask.getTaskCode(), "trigger").withSchedule((ScheduleBuilder)cronScheduleBuilder).build();
        this.scheduler.scheduleJob(taskTest, (Trigger)build);
        sysTask.setTaskStatus(TaskStatusEnum.START.getCode());
        this.sysTaskService.updateById(sysTask);
        return Result.ok();
    }

    @Override
    public Result stop(String taskId) throws Exception {
        SysTask sysTask = (SysTask)this.sysTaskService.getById((Serializable)((Object)taskId));
        if (Objects.isNull(sysTask)) {
            return Result.build((ResultConstant)TaskResultEnum.NOT_CHECK_FILE);
        }
        JobKey jobKey = JobKey.jobKey((String)sysTask.getTaskCode(), (String)"job");
        JobDetail jobDetail = this.scheduler.getJobDetail(jobKey);
        if (jobDetail == null) {
            return Result.ok();
        }
        this.scheduler.pauseJob(jobKey);
        sysTask.setTaskStatus(TaskStatusEnum.STOP.getCode());
        this.sysTaskService.updateById(sysTask);
        return Result.ok();
    }

    @Override
    public Result restart(String taskId) throws Exception {
        SysTask sysTask = (SysTask)this.sysTaskService.getById((Serializable)((Object)taskId));
        if (Objects.isNull(sysTask)) {
            return Result.build((ResultConstant)TaskResultEnum.NOT_CHECK_FILE);
        }
        JobKey jobKey = JobKey.jobKey((String)sysTask.getTaskCode(), (String)"job");
        JobDetail jobDetail = this.scheduler.getJobDetail(jobKey);
        if (jobDetail == null) {
            return Result.ok();
        }
        this.scheduler.resumeJob(jobKey);
        sysTask.setTaskStatus(TaskStatusEnum.START.getCode());
        this.sysTaskService.updateById(sysTask);
        return Result.ok();
    }

    @Override
    public Result remove(String taskId) throws Exception {
        SysTask sysTask = (SysTask)this.sysTaskService.getById((Serializable)((Object)taskId));
        if (Objects.isNull(sysTask)) {
            return Result.build((ResultConstant)TaskResultEnum.NOT_CHECK_FILE);
        }
        TriggerKey triggerKey = TriggerKey.triggerKey((String)sysTask.getTaskCode(), (String)"trigger");
        JobKey jobKey = JobKey.jobKey((String)sysTask.getTaskCode(), (String)"job");
        Trigger trigger = this.scheduler.getTrigger(triggerKey);
        if (trigger == null) {
            return Result.ok();
        }
        this.scheduler.pauseTrigger(triggerKey);
        this.scheduler.unscheduleJob(triggerKey);
        this.scheduler.deleteJob(jobKey);
        sysTask.setTaskStatus(TaskStatusEnum.REMOVE.getCode());
        this.sysTaskService.updateById(sysTask);
        return Result.ok();
    }
}

