/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.task.config;

import cn.hutool.core.collection.CollUtil;
import com.efficient.task.api.SysTaskService;
import com.efficient.task.constant.TaskStatusEnum;
import com.efficient.task.model.entity.SysTask;
import com.efficient.task.properties.TaskProperties;
import java.util.List;
import javax.annotation.PostConstruct;
import org.mybatis.spring.annotation.MapperScan;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.quartz.QuartzJobBean;

@Configuration
@EnableConfigurationProperties(value={TaskProperties.class})
@MapperScan(basePackages={"com.efficient.task.dao"})
public class TaskConfig {
    private static final Logger log = LoggerFactory.getLogger(TaskConfig.class);
    @Autowired
    private TaskProperties taskProperties;
    @Autowired
    private SysTaskService sysTaskService;
    @Autowired
    private Scheduler scheduler;

    @PostConstruct
    public void initTask() {
        if (!this.taskProperties.getEnable().booleanValue()) {
            return;
        }
        try {
            List<SysTask> taskList = this.sysTaskService.findAll();
            if (CollUtil.isEmpty(taskList)) {
                log.info(" No scheduled tasks!");
                return;
            }
            for (SysTask sysTask : taskList) {
                String taskClass = sysTask.getTaskClass();
                Class<?> aClass = null;
                try {
                    Class<?> bClass = Class.forName(taskClass);
                    if (!QuartzJobBean.class.isAssignableFrom(bClass) && !Job.class.isAssignableFrom(bClass)) {
                        log.error("\u914d\u7f6e\u7684\u7c7b\u540d\u9700\u5b9e\u73b0QuartzJobBean\u6216\u8005Job\u63a5\u53e3\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u8868\uff01");
                        continue;
                    }
                    aClass = bClass;
                }
                catch (ClassNotFoundException e) {
                    log.error("\u914d\u7f6e\u7684\u7c7b\u540d\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u8868\uff01", (Throwable)e);
                    continue;
                }
                JobDetail taskTest = JobBuilder.newJob(aClass).withIdentity(sysTask.getTaskCode(), "job").storeDurably().build();
                CronScheduleBuilder cronScheduleBuilder = CronScheduleBuilder.cronSchedule((String)sysTask.getCronExpression());
                CronTrigger build = (CronTrigger)TriggerBuilder.newTrigger().forJob(taskTest).withIdentity(sysTask.getTaskCode(), "trigger").withSchedule((ScheduleBuilder)cronScheduleBuilder).build();
                this.scheduler.scheduleJob(taskTest, (Trigger)build);
                log.info("\u6210\u529f\u52a0\u8f7d\u5b9a\u65f6\u4efb\u52a1\uff1a" + sysTask.getTaskCode());
                sysTask.setTaskStatus(TaskStatusEnum.START.getCode());
            }
            this.sysTaskService.saveOrUpdateBatch(taskList);
        }
        catch (Exception e) {
            log.error("\u5b9a\u65f6\u4efb\u52a1\u542f\u52a8\u5931\u8d25\uff01", (Throwable)e);
        }
    }
}

