/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.task.controller;

import com.efficient.common.result.Result;
import com.efficient.task.api.SysTaskService;
import com.efficient.task.model.dto.SysTaskDTO;
import com.efficient.task.model.dto.SysTaskListDTO;
import com.efficient.task.model.entity.SysTask;
import com.efficient.task.model.vo.SysTaskVO;
import javax.validation.constraints.NotBlank;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sysTask"})
@Validated
public class SysTaskController {
    @Autowired
    private SysTaskService sysTaskService;

    @PostMapping(value={"/save"})
    public Result save(@Validated @RequestBody SysTaskDTO dto) {
        SysTask entity = this.sysTaskService.save(dto);
        return Result.ok((Object)entity);
    }

    @GetMapping(value={"/find"})
    public Result find(@NotBlank(message="id \u4e0d\u80fd\u4e3a\u7a7a") @RequestParam(name="id") @NotBlank(message="id \u4e0d\u80fd\u4e3a\u7a7a") String id) {
        SysTaskVO entity = this.sysTaskService.findById(id);
        return Result.ok((Object)entity);
    }

    @PostMapping(value={"/update"})
    public Result update(@Validated @RequestBody SysTaskDTO dto) {
        boolean flag = this.sysTaskService.update(dto);
        return flag ? Result.ok() : Result.fail();
    }

    @GetMapping(value={"/delete"})
    public Result delete(@NotBlank(message="id \u4e0d\u80fd\u4e3a\u7a7a") @RequestParam(name="id") @NotBlank(message="id \u4e0d\u80fd\u4e3a\u7a7a") String id) {
        boolean flag = this.sysTaskService.delete(id);
        return flag ? Result.ok() : Result.fail();
    }

    @PostMapping(value={"/list"})
    public Result list(@Validated @RequestBody SysTaskListDTO dto) {
        return Result.ok(this.sysTaskService.list(dto));
    }
}

