/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.task.service;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.efficient.common.result.Result;
import com.efficient.common.result.ResultConstant;
import com.efficient.task.api.SysTaskService;
import com.efficient.task.constant.TaskResultEnum;
import com.efficient.task.dao.SysTaskMapper;
import com.efficient.task.model.converter.SysTaskConverter;
import com.efficient.task.model.dto.SysTaskDTO;
import com.efficient.task.model.dto.SysTaskListDTO;
import com.efficient.task.model.entity.SysTask;
import com.efficient.task.model.vo.SysTaskVO;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysTaskServiceImpl
extends ServiceImpl<SysTaskMapper, SysTask>
implements SysTaskService {
    @Autowired
    private SysTaskConverter sysTaskConverter;
    @Autowired
    private SysTaskMapper sysTaskMapper;

    @Override
    public Result<SysTask> save(SysTaskDTO dto) {
        String taskCode = dto.getTaskCode();
        SysTask sysTask = this.findByCode(taskCode);
        if (Objects.nonNull(sysTask)) {
            return Result.build((ResultConstant)TaskResultEnum.TASK_CODE_EXIST);
        }
        SysTask entity = this.sysTaskConverter.dto2Entity(dto);
        boolean flag = this.save(entity);
        return Result.ok((Object)entity);
    }

    @Override
    public SysTask findByCode(String code) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysTask::getTaskCode, (Object)code);
        queryWrapper.last(" limit 1");
        return (SysTask)this.sysTaskMapper.selectOne((Wrapper)queryWrapper);
    }

    @Override
    public SysTaskVO findById(String id) {
        SysTask entity = (SysTask)this.getById((Serializable)((Object)id));
        return this.sysTaskConverter.entity2Vo(entity);
    }

    @Override
    public Result<Boolean> update(SysTaskDTO dto) {
        SysTask sysTask = this.sysTaskConverter.dto2Entity(dto);
        SysTask oldTask = this.findByCode(dto.getTaskCode());
        if (Objects.nonNull(oldTask) && !Objects.equals(oldTask.getId(), sysTask.getId())) {
            return Result.build((ResultConstant)TaskResultEnum.TASK_CODE_EXIST);
        }
        boolean updatedById = this.updateById(sysTask);
        return updatedById ? Result.ok() : Result.fail();
    }

    @Override
    public Boolean delete(String id) {
        return this.removeById((Serializable)((Object)id));
    }

    @Override
    public Page<SysTask> list(SysTaskListDTO dto) {
        Page page = (Page)this.sysTaskMapper.selectPage((IPage)new Page((long)dto.getPageNum().intValue(), (long)dto.getPageSize().intValue()), (Wrapper)new QueryWrapper());
        return page;
    }

    @Override
    public List<SysTask> findAll() {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysTask::getEnabled, (Object)1);
        return this.list((Wrapper)queryWrapper);
    }
}

